<?php
declare(strict_types=1);

class StockMovement extends Model
{
    public function all(): array
    {
        $sql = "SELECT s.id, s.type, s.qty, s.ref, s.created_at, m.name AS medicine
                FROM stock_movements s
                INNER JOIN medicines m ON m.id = s.medicine_id
                ORDER BY s.created_at DESC, s.id DESC";
        $stmt = $this->db()->query($sql);
        return $stmt->fetchAll();
    }

    public function stockLevels(): array
    {
        $sql = "SELECT m.id, m.name,
                       SUM(CASE WHEN s.type='IN' THEN s.qty ELSE 0 END) AS qty_in,
                       SUM(CASE WHEN s.type='OUT' THEN s.qty ELSE 0 END) AS qty_out,
                       (SUM(CASE WHEN s.type='IN' THEN s.qty ELSE 0 END) - SUM(CASE WHEN s.type='OUT' THEN s.qty ELSE 0 END)) AS balance
                FROM medicines m
                LEFT JOIN stock_movements s ON s.medicine_id = m.id
                GROUP BY m.id, m.name
                ORDER BY m.name";
        $stmt = $this->db()->query($sql);
        return $stmt->fetchAll();
    }

    public function addIn(int $medicineId, float $qty, ?string $ref = null): void
    {
        $stmt = $this->db()->prepare("INSERT INTO stock_movements (medicine_id, type, qty, ref, created_at) VALUES (:mid, 'IN', :qty, :ref, NOW())");
        $stmt->execute([':mid' => $medicineId, ':qty' => $qty, ':ref' => $ref]);
    }

    public function addOut(int $medicineId, float $qty, ?string $ref = null): void
    {
        $stmt = $this->db()->prepare("INSERT INTO stock_movements (medicine_id, type, qty, ref, created_at) VALUES (:mid, 'OUT', :qty, :ref, NOW())");
        $stmt->execute([':mid' => $medicineId, ':qty' => $qty, ':ref' => $ref]);
    }

    public function medicines(): array
    {
        $stmt = $this->db()->query("SELECT id, name FROM medicines ORDER BY name");
        return $stmt->fetchAll();
    }
}
