<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Add Bed') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-success text-white">
            <h2 class="h5 mb-0"><i class="fas fa-bed me-2"></i>Add Bed to Room/Ward</h2>
          </div>
          <div class="card-body p-4">
            <div class="alert alert-info">
              <i class="fas fa-info-circle me-2"></i>
              <strong>Room:</strong> <?= htmlspecialchars($room['name'] ?? '') ?>
              <?php if (!empty($room['code'])): ?>
                <span class="badge bg-secondary ms-2"><?= htmlspecialchars($room['code']) ?></span>
              <?php endif; ?>
            </div>

            <form method="post" action="<?= htmlspecialchars($base) ?>/rooms/store-bed">
              <input type="hidden" name="room_id" value="<?= (int)($room['id'] ?? 0) ?>">
              
              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label fw-semibold">Ward Name <span class="text-danger">*</span></label>
                  <input name="ward" value="<?= htmlspecialchars($room['name'] ?? '') ?>" class="form-control form-control-lg" required placeholder="e.g., General Ward A" />
                  <small class="text-muted">Usually same as room name or ward identifier</small>
                </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label fw-semibold">Bed Number <span class="text-danger">*</span></label>
                  <input name="number" class="form-control form-control-lg" required placeholder="e.g., 1, 2, A1, B2" />
                  <small class="text-muted">Unique bed number within this ward</small>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label fw-semibold">Bed Type</label>
                <select name="type" class="form-select form-select-lg">
                  <option value="">-- Select Type (Optional) --</option>
                  <option value="Standard">Standard</option>
                  <option value="ICU">ICU</option>
                  <option value="CCU">CCU</option>
                  <option value="Emergency">Emergency</option>
                  <option value="Isolation">Isolation</option>
                  <option value="Other">Other</option>
                </select>
              </div>

              <div class="d-flex justify-content-end gap-2 mt-4">
                <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/rooms/view?id=<?= urlencode((string)($room['id'] ?? 0)) ?>">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button class="btn btn-success btn-lg" type="submit">
                  <i class="fas fa-save me-2"></i>Add Bed
                </button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






