<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Edit Room/Ward') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .form-section {
      background: #f8f9fa;
      border-radius: 8px;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
    }
    .section-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #495057;
      margin-bottom: 1rem;
      padding-bottom: 0.5rem;
      border-bottom: 2px solid #dee2e6;
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <h2 class="h5 mb-0"><i class="fas fa-edit me-2"></i>Edit Room/Ward</h2>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? null;
              $formErrors = $_SESSION['form_errors'] ?? [];
              $old = $_SESSION['old'] ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base) ?>/rooms/update">
              <input type="hidden" name="id" value="<?= (int)($room['id'] ?? 0) ?>">
              
              <!-- Basic Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-info-circle me-2"></i>Basic Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Room/Ward Name <span class="text-danger">*</span></label>
                    <input name="name" value="<?= htmlspecialchars($old['name'] ?? $room['name'] ?? '') ?>" class="form-control form-control-lg" required />
                    <?php if (!empty($formErrors['name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['name']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Room Code</label>
                    <input name="code" value="<?= htmlspecialchars($old['code'] ?? $room['code'] ?? '') ?>" class="form-control form-control-lg" />
                    <?php if (!empty($formErrors['code'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['code']) ?></div><?php endif; ?>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Room Type <span class="text-danger">*</span></label>
                    <select name="room_type" class="form-select form-select-lg" required>
                      <?php foreach (($roomTypes ?? []) as $type): ?>
                        <option value="<?= htmlspecialchars($type) ?>" <?= ((isset($old['room_type']) && $old['room_type'] === $type) || (!isset($old['room_type']) && isset($room['room_type']) && $room['room_type'] === $type)) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($type) ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Capacity (Beds) <span class="text-danger">*</span></label>
                    <input type="number" name="capacity" value="<?= htmlspecialchars($old['capacity'] ?? $room['capacity'] ?? '1') ?>" min="1" class="form-control form-control-lg" required />
                    <?php if (!empty($formErrors['capacity'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['capacity']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <!-- Location Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-map-marker-alt me-2"></i>Location Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Building</label>
                    <input name="building" value="<?= htmlspecialchars($old['building'] ?? $room['building'] ?? '') ?>" class="form-control form-control-lg" />
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Floor</label>
                    <input name="floor" value="<?= htmlspecialchars($old['floor'] ?? $room['floor'] ?? '') ?>" class="form-control form-control-lg" />
                  </div>
                </div>
              </div>

              <!-- Pricing Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-rupee-sign me-2"></i>Pricing Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Charge per Day (₹)</label>
                    <div class="input-group input-group-lg">
                      <span class="input-group-text bg-light">₹</span>
                      <input type="number" name="charge_per_day" value="<?= htmlspecialchars($old['charge_per_day'] ?? $room['charge_per_day'] ?? '0.00') ?>" step="0.01" min="0" class="form-control" />
                    </div>
                    <?php if (!empty($formErrors['charge_per_day'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['charge_per_day']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Status</label>
                    <select name="status" class="form-select form-select-lg">
                      <option value="1" <?= ((isset($old['status']) && (int)$old['status'] === 1) || (!isset($old['status']) && isset($room['status']) && (int)$room['status'] === 1)) ? 'selected' : '' ?>>Active</option>
                      <option value="0" <?= ((isset($old['status']) && (int)$old['status'] === 0) || (!isset($old['status']) && isset($room['status']) && (int)$room['status'] === 0)) ? 'selected' : '' ?>>Inactive</option>
                    </select>
                  </div>
                </div>
              </div>

              <!-- Additional Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-align-left me-2"></i>Additional Information</div>
                <div class="mb-3">
                  <label class="form-label fw-semibold">Description</label>
                  <textarea name="description" class="form-control" rows="4"><?= htmlspecialchars($old['description'] ?? $room['description'] ?? '') ?></textarea>
                </div>
              </div>

              <div class="d-flex justify-content-end gap-2 mt-4">
                <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/rooms">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button class="btn btn-primary btn-lg" type="submit">
                  <i class="fas fa-save me-2"></i>Save Changes
                </button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

