<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .room-card {
      transition: transform 0.2s, box-shadow 0.2s;
      border-left: 4px solid #0d6efd;
    }
    .room-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .room-type-badge {
      font-size: 0.75rem;
      padding: 0.35rem 0.65rem;
    }
    .bed-status {
      font-size: 0.85rem;
    }
    .filter-card {
      background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
      color: white;
      border-radius: 12px;
    }
    .capacity-bar {
      height: 8px;
      border-radius: 4px;
      background: #e9ecef;
      overflow: hidden;
    }
    .capacity-fill {
      height: 100%;
      background: linear-gradient(90deg, #11998e 0%, #38ef7d 100%);
      transition: width 0.3s;
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-hospital text-primary me-2"></i>Rooms & Wards Management</h1>
            <p class="text-muted mb-0">Manage hospital rooms, wards, and bed allocation</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/rooms/add" class="btn btn-primary btn-lg shadow-sm">
              <i class="fas fa-plus-circle me-2"></i>Add New Room/Ward
            </a>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/rooms" class="row g-3">
              <div class="col-md-4">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search rooms/wards..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-filter me-2"></i>Room Type</label>
                <select name="room_type" class="form-select form-select-lg">
                  <option value="">All Types</option>
                  <?php foreach (($roomTypes ?? []) as $type): ?>
                    <option value="<?= htmlspecialchars($type) ?>" <?= (isset($room_type) && $room_type === $type) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($type) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-toggle-on me-2"></i>Status</label>
                <select name="status" class="form-select form-select-lg">
                  <option value="">All</option>
                  <option value="1" <?= (isset($status) && $status === 1) ? 'selected' : '' ?>>Active</option>
                  <option value="0" <?= (isset($status) && $status === 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
              </div>
              <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Rooms Grid -->
        <?php if (!empty($rooms)): ?>
          <div class="row g-4">
            <?php foreach ($rooms as $room): 
              $totalBeds = (int)($room['total_beds'] ?? 0);
              $availableBeds = (int)($room['available_beds'] ?? 0);
              $occupiedBeds = $totalBeds - $availableBeds;
              $capacity = (int)($room['capacity'] ?? 1);
              $bedUtilization = $totalBeds > 0 ? ($occupiedBeds / $totalBeds) * 100 : 0;
            ?>
              <div class="col-md-6 col-lg-4">
                <div class="card room-card shadow-sm h-100">
                  <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                      <div>
                        <h5 class="card-title mb-1 fw-bold"><?= htmlspecialchars($room['name'] ?? '') ?></h5>
                        <?php if (!empty($room['code'])): ?>
                          <span class="badge bg-secondary room-type-badge"><?= htmlspecialchars($room['code']) ?></span>
                        <?php endif; ?>
                      </div>
                      <span class="badge bg-<?= ((isset($room['status']) && (int)$room['status'] === 1) ? 'success' : 'secondary') ?> room-type-badge">
                        <?= ((isset($room['status']) && (int)$room['status'] === 1) ? 'Active' : 'Inactive') ?>
                      </span>
                    </div>
                    
                    <div class="mb-3">
                      <span class="badge bg-primary room-type-badge">
                        <i class="fas fa-door-open me-1"></i><?= htmlspecialchars($room['room_type'] ?? 'General') ?>
                      </span>
                      <?php if (!empty($room['floor'])): ?>
                        <span class="badge bg-info room-type-badge ms-1">
                          <i class="fas fa-layer-group me-1"></i>Floor <?= htmlspecialchars($room['floor']) ?>
                        </span>
                      <?php endif; ?>
                      <?php if (!empty($room['building'])): ?>
                        <span class="badge bg-warning text-dark room-type-badge ms-1">
                          <i class="fas fa-building me-1"></i><?= htmlspecialchars($room['building']) ?>
                        </span>
                      <?php endif; ?>
                    </div>

                    <!-- Bed Status -->
                    <div class="mb-3 p-3 bg-light rounded">
                      <div class="d-flex justify-content-between align-items-center mb-2">
                        <span class="fw-semibold bed-status">Bed Status</span>
                        <span class="text-muted small">Capacity: <?= $capacity ?></span>
                      </div>
                      <div class="capacity-bar mb-2">
                        <div class="capacity-fill" style="width: <?= min($bedUtilization, 100) ?>%"></div>
                      </div>
                      <div class="d-flex justify-content-between small">
                        <span class="text-success"><i class="fas fa-bed me-1"></i>Available: <?= $availableBeds ?></span>
                        <span class="text-danger"><i class="fas fa-bed me-1"></i>Occupied: <?= $occupiedBeds ?></span>
                        <span class="text-muted"><i class="fas fa-bed me-1"></i>Total: <?= $totalBeds ?></span>
                      </div>
                    </div>

                    <!-- Charge Info -->
                    <?php if ((float)($room['charge_per_day'] ?? 0) > 0): ?>
                      <div class="mb-3">
                        <span class="text-muted small">Charge per day:</span>
                        <span class="fw-bold text-success">₹<?= number_format((float)($room['charge_per_day'] ?? 0), 2) ?></span>
                      </div>
                    <?php endif; ?>

                    <div class="d-flex gap-2 mt-auto">
                      <a href="<?= htmlspecialchars($base) ?>/rooms/view?id=<?= urlencode((string)($room['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-secondary flex-fill">
                        <i class="fas fa-eye me-1"></i>View
                      </a>
                      <a href="<?= htmlspecialchars($base) ?>/rooms/edit?id=<?= urlencode((string)($room['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-primary flex-fill">
                        <i class="fas fa-edit me-1"></i>Edit
                      </a>
                      <?php if (isset($room['status']) && (int)$room['status'] === 1): ?>
                        <form method="post" action="<?= htmlspecialchars($base) ?>/rooms/deactivate" style="display:inline-block" onsubmit="return confirm('Deactivate this room/ward?');" class="flex-fill">
                          <input type="hidden" name="id" value="<?= (int)($room['id'] ?? 0) ?>">
                          <button type="submit" class="btn btn-sm btn-outline-warning w-100">
                            <i class="fas fa-ban me-1"></i>Deactivate
                          </button>
                        </form>
                      <?php else: ?>
                        <form method="post" action="<?= htmlspecialchars($base) ?>/rooms/restore" style="display:inline-block" onsubmit="return confirm('Restore this room/ward?');" class="flex-fill">
                          <input type="hidden" name="id" value="<?= (int)($room['id'] ?? 0) ?>">
                          <button type="submit" class="btn btn-sm btn-outline-success w-100">
                            <i class="fas fa-check me-1"></i>Restore
                          </button>
                        </form>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php else: ?>
          <div class="card shadow-sm border-0">
            <div class="card-body text-center py-5">
              <i class="fas fa-hospital fa-3x text-muted mb-3"></i>
              <h5 class="text-muted">No rooms/wards found</h5>
              <p class="text-muted">Get started by adding your first room/ward</p>
              <a href="<?= htmlspecialchars($base) ?>/rooms/add" class="btn btn-primary">
                <i class="fas fa-plus-circle me-2"></i>Add New Room/Ward
              </a>
            </div>
          </div>
        <?php endif; ?>

        <!-- Pagination -->
        <?php
          $total = (int)($total ?? 0);
          $perPage = (int)($perPage ?? 20);
          $page = (int)($page ?? 1);
          $pages = $perPage > 0 ? (int)ceil($total / $perPage) : 1;
        ?>
        <?php if ($pages > 1): ?>
          <nav class="mt-4" aria-label="Rooms pagination">
            <ul class="pagination justify-content-center">
              <?php for ($p = 1; $p <= $pages; $p++): ?>
                <li class="page-item <?= $p === $page ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/rooms?page=<?= $p ?>&q=<?= urlencode((string)($q ?? '')) ?>&status=<?= urlencode((string)($status ?? '')) ?>&room_type=<?= urlencode((string)($room_type ?? '')) ?>"><?= $p ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>






