<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Room/Ward Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .info-card {
      border-left: 4px solid #0d6efd;
      transition: transform 0.2s;
    }
    .info-card:hover {
      transform: translateX(5px);
    }
    .bed-card {
      border: 2px solid #dee2e6;
      border-radius: 8px;
      padding: 1rem;
      transition: all 0.2s;
    }
    .bed-card.available {
      border-color: #198754;
      background: #f0fdf4;
    }
    .bed-card.occupied {
      border-color: #dc3545;
      background: #fef2f2;
    }
    .bed-card:hover {
      transform: scale(1.02);
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-hospital text-primary me-2"></i>Room/Ward Details</h1>
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= htmlspecialchars($base) ?>/rooms">Rooms & Wards</a></li>
                <li class="breadcrumb-item active">Details</li>
              </ol>
            </nav>
          </div>
          <div>
            <a class="btn btn-outline-primary" href="<?= htmlspecialchars($base) ?>/rooms/edit?id=<?= urlencode((string)($room['id'] ?? 0)) ?>">
              <i class="fas fa-edit me-2"></i>Edit
            </a>
            <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/rooms">
              <i class="fas fa-arrow-left me-2"></i>Back
            </a>
          </div>
        </div>

        <div class="row g-4">
          <!-- Room Information -->
          <div class="col-md-4">
            <div class="card info-card shadow-sm border-0">
              <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Room Information</h5>
              </div>
              <div class="card-body">
                <table class="table table-borderless mb-0">
                  <tr>
                    <th width="40%">Room ID</th>
                    <td>#<?= (int)($room['id'] ?? 0) ?></td>
                  </tr>
                  <tr>
                    <th>Name</th>
                    <td><?= htmlspecialchars($room['name'] ?? 'N/A') ?></td>
                  </tr>
                  <tr>
                    <th>Code</th>
                    <td><?= !empty($room['code']) ? htmlspecialchars($room['code']) : '<span class="text-muted">N/A</span>' ?></td>
                  </tr>
                  <tr>
                    <th>Type</th>
                    <td><span class="badge bg-primary"><?= htmlspecialchars($room['room_type'] ?? 'General') ?></span></td>
                  </tr>
                  <tr>
                    <th>Capacity</th>
                    <td><?= (int)($room['capacity'] ?? 1) ?> beds</td>
                  </tr>
                  <tr>
                    <th>Status</th>
                    <td>
                      <?= ((isset($room['status']) && (int)$room['status'] === 1) ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>') ?>
                    </td>
                  </tr>
                </table>
              </div>
            </div>
          </div>

          <!-- Location & Pricing -->
          <div class="col-md-4">
            <div class="card info-card shadow-sm border-0">
              <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-map-marker-alt me-2"></i>Location & Pricing</h5>
              </div>
              <div class="card-body">
                <table class="table table-borderless mb-0">
                  <tr>
                    <th width="40%">Building</th>
                    <td><?= !empty($room['building']) ? htmlspecialchars($room['building']) : '<span class="text-muted">N/A</span>' ?></td>
                  </tr>
                  <tr>
                    <th>Floor</th>
                    <td><?= !empty($room['floor']) ? htmlspecialchars($room['floor']) : '<span class="text-muted">N/A</span>' ?></td>
                  </tr>
                  <tr>
                    <th>Charge/Day</th>
                    <td class="fw-bold text-success">₹<?= number_format((float)($room['charge_per_day'] ?? 0), 2) ?></td>
                  </tr>
                </table>
              </div>
            </div>
          </div>

          <!-- Bed Statistics -->
          <div class="col-md-4">
            <div class="card shadow-sm border-0" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); color: white;">
              <div class="card-body text-center p-4">
                <i class="fas fa-bed fa-3x mb-3 opacity-75"></i>
                <h3 class="mb-2">Bed Status</h3>
                <div class="display-4 fw-bold mb-2"><?= (int)($room['available_beds'] ?? 0) ?>/<?= (int)($room['total_beds'] ?? 0) ?></div>
                <p class="mb-0 opacity-75">Available Beds</p>
                <div class="mt-3">
                  <span class="badge bg-light text-dark me-2">Total: <?= (int)($room['total_beds'] ?? 0) ?></span>
                  <span class="badge bg-light text-dark">Occupied: <?= (int)($room['total_beds'] ?? 0) - (int)($room['available_beds'] ?? 0) ?></span>
                </div>
              </div>
            </div>
          </div>

          <!-- Description -->
          <?php if (!empty($room['description'])): ?>
            <div class="col-12">
              <div class="card shadow-sm border-0">
                <div class="card-header bg-light">
                  <h5 class="mb-0"><i class="fas fa-align-left me-2"></i>Description</h5>
                </div>
                <div class="card-body">
                  <p class="mb-0"><?= nl2br(htmlspecialchars($room['description'])) ?></p>
                </div>
              </div>
            </div>
          <?php endif; ?>

          <!-- Bed Allocation -->
          <div class="col-12">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-bed me-2"></i>Bed Allocation</h5>
                <a href="<?= htmlspecialchars($base) ?>/rooms/add-bed?room_id=<?= urlencode((string)($room['id'] ?? 0)) ?>" class="btn btn-sm btn-primary">
                  <i class="fas fa-plus me-1"></i>Add Bed
                </a>
              </div>
              <div class="card-body">
                <?php if (!empty($beds)): ?>
                  <div class="row g-3">
                    <?php foreach ($beds as $bed): 
                      $isOccupied = isset($bed['is_occupied']) && (int)$bed['is_occupied'] > 0;
                      $isAvailable = isset($bed['is_available']) && (int)$bed['is_available'] === 1 && !$isOccupied;
                    ?>
                      <div class="col-md-3 col-sm-4 col-6">
                        <div class="bed-card <?= $isAvailable ? 'available' : 'occupied' ?>">
                          <div class="d-flex justify-content-between align-items-start mb-2">
                            <div>
                              <h6 class="mb-0 fw-bold">Bed #<?= htmlspecialchars($bed['number'] ?? '') ?></h6>
                              <small class="text-muted"><?= htmlspecialchars($bed['ward'] ?? '') ?></small>
                            </div>
                            <?php if ($isAvailable): ?>
                              <span class="badge bg-success"><i class="fas fa-check"></i></span>
                            <?php else: ?>
                              <span class="badge bg-danger"><i class="fas fa-times"></i></span>
                            <?php endif; ?>
                          </div>
                          <?php if (!empty($bed['type'])): ?>
                            <span class="badge bg-secondary"><?= htmlspecialchars($bed['type']) ?></span>
                          <?php endif; ?>
                          <div class="mt-2">
                            <small class="text-muted">
                              Status: <strong><?= $isAvailable ? 'Available' : 'Occupied' ?></strong>
                            </small>
                          </div>
                          <div class="d-flex gap-1 mt-3">
                            <a href="<?= htmlspecialchars($base) ?>/rooms/edit-bed?bed_id=<?= urlencode((string)($bed['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-primary flex-fill">
                              <i class="fas fa-edit"></i> Edit
                            </a>
                            <?php if ($isAvailable): ?>
                              <form method="post" action="<?= htmlspecialchars($base) ?>/rooms/delete-bed" style="display:inline-block" onsubmit="return confirm('Are you sure you want to delete this bed?');" class="flex-fill">
                                <input type="hidden" name="bed_id" value="<?= (int)($bed['id'] ?? 0) ?>">
                                <input type="hidden" name="room_id" value="<?= (int)($room['id'] ?? 0) ?>">
                                <button type="submit" class="btn btn-sm btn-outline-danger w-100">
                                  <i class="fas fa-trash"></i> Delete
                                </button>
                              </form>
                            <?php else: ?>
                              <button class="btn btn-sm btn-outline-secondary flex-fill" disabled title="Cannot delete occupied bed">
                                <i class="fas fa-lock"></i> Locked
                              </button>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    <?php endforeach; ?>
                  </div>
                <?php else: ?>
                  <div class="text-center py-4">
                    <i class="fas fa-bed fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No beds allocated to this room yet.</p>
                    <a href="<?= htmlspecialchars($base) ?>/rooms/add-bed?room_id=<?= urlencode((string)($room['id'] ?? 0)) ?>" class="btn btn-primary">
                      <i class="fas fa-plus me-2"></i>Add First Bed
                    </a>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

