<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Add Service') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-body">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? null;
              $formErrors = $_SESSION['form_errors'] ?? [];
              $old = $_SESSION['old'] ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger"><?= htmlspecialchars($formError) ?></div>
            <?php endif; ?>
            <h2 class="h5 mb-3">Add New Service</h2>
            <form method="post" action="<?= htmlspecialchars($base) ?>/services/store">
              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label">Service Name <span class="text-danger">*</span></label>
                  <input name="name" value="<?= htmlspecialchars($old['name'] ?? '') ?>" class="form-control" required />
                  <?php if (!empty($formErrors['name'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['name']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label">Service Code</label>
                  <input name="code" value="<?= htmlspecialchars($old['code'] ?? '') ?>" class="form-control" />
                  <?php if (!empty($formErrors['code'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['code']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label">Department</label>
                  <select name="department_id" class="form-select">
                    <option value="">-- Select Department --</option>
                    <?php foreach (($departments ?? []) as $dept): ?>
                      <option value="<?= (int)($dept['id'] ?? 0) ?>" <?= (isset($old['department_id']) && (int)$old['department_id'] === (int)($dept['id'] ?? 0)) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($dept['name'] ?? '') ?>
                      </option>
                    <?php endforeach; ?>
                  </select>
                  <?php if (!empty($formErrors['department_id'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['department_id']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label">Price (₹) <span class="text-danger">*</span></label>
                  <input type="number" name="price" value="<?= htmlspecialchars($old['price'] ?? '0.00') ?>" step="0.01" min="0" class="form-control" required />
                  <?php if (!empty($formErrors['price'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['price']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label">Description</label>
                <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($old['description'] ?? '') ?></textarea>
                <?php if (!empty($formErrors['description'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['description']) ?></div><?php endif; ?>
              </div>

              <div class="mb-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                  <option value="1" <?= ((isset($old['status']) && (int)$old['status'] === 1) || !isset($old['status'])) ? 'selected' : '' ?>>Active</option>
                  <option value="0" <?= (isset($old['status']) && (int)$old['status'] === 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
                <?php if (!empty($formErrors['status'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['status']) ?></div><?php endif; ?>
              </div>

              <div class="text-end">
                <button class="btn btn-primary" type="submit">Save</button>
                <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/services">Cancel</a>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






