<?php declare(strict_types=1);
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
          <div class="w-100 mb-2">
            <h1 class="h4 mb-1"><?= htmlspecialchars($title ?? 'Services') ?></h1>
            <form class="row g-2" method="get" action="<?= htmlspecialchars($base) ?>/services">
              <div class="col-auto">
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search services..." class="form-control form-control-sm" />
              </div>
              <div class="col-auto">
                <select name="department_id" class="form-select form-select-sm">
                  <option value="">All Departments</option>
                  <?php foreach (($departments ?? []) as $dept): ?>
                    <option value="<?= (int)($dept['id'] ?? 0) ?>" <?= (isset($department_id) && (int)$department_id === (int)($dept['id'] ?? 0)) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($dept['name'] ?? '') ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-auto">
                <select name="status" class="form-select form-select-sm">
                  <option value="">All</option>
                  <option value="1" <?= (isset($status) && $status === 1) ? 'selected' : '' ?>>Active</option>
                  <option value="0" <?= (isset($status) && $status === 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
              </div>
              <div class="col-auto">
                <button class="btn btn-sm btn-primary" type="submit">Filter</button>
              </div>
            </form>
          </div>
          <div>
            <a href="<?= htmlspecialchars($base) ?>/services/add" class="btn btn-primary">Add Service</a>
          </div>
        </div>

        <div class="card border-0 shadow-sm">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Code</th>
                    <th>Department</th>
                    <th>Price</th>
                    <th>Status</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($services)): ?>
                    <?php foreach ($services as $s): ?>
                    <tr>
                      <td><?= (int)($s['id'] ?? 0) ?></td>
                      <td><?= htmlspecialchars($s['name'] ?? '') ?></td>
                      <td><?= htmlspecialchars($s['code'] ?? '') ?></td>
                      <td><?= htmlspecialchars($s['department_name'] ?? 'N/A') ?></td>
                      <td>₹<?= number_format((float)($s['price'] ?? 0), 2) ?></td>
                      <td><?= ((isset($s['status']) && (int)$s['status'] === 1) ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>') ?></td>
                      <td class="text-end">
                        <a href="<?= htmlspecialchars($base) ?>/services/view?id=<?= urlencode((string)($s['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-secondary">View</a>
                        <a href="<?= htmlspecialchars($base) ?>/services/edit?id=<?= urlencode((string)($s['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-primary ms-1">Edit</a>
                        <?php if (isset($s['status']) && (int)$s['status'] === 1): ?>
                          <form method="post" action="<?= htmlspecialchars($base) ?>/services/deactivate" style="display:inline-block" onsubmit="return confirm('Deactivate this service?');">
                            <input type="hidden" name="id" value="<?= (int)($s['id'] ?? 0) ?>">
                            <button type="submit" class="btn btn-sm btn-outline-warning ms-1">Deactivate</button>
                          </form>
                        <?php else: ?>
                          <form method="post" action="<?= htmlspecialchars($base) ?>/services/restore" style="display:inline-block" onsubmit="return confirm('Restore this service?');">
                            <input type="hidden" name="id" value="<?= (int)($s['id'] ?? 0) ?>">
                            <button type="submit" class="btn btn-sm btn-outline-success ms-1">Restore</button>
                          </form>
                        <?php endif; ?>
                      </td>
                    </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr><td colspan="7" class="text-center text-muted py-4">No services found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <?php
          // Pagination
          $total = (int)($total ?? 0);
          $perPage = (int)($perPage ?? 20);
          $page = (int)($page ?? 1);
          $pages = $perPage > 0 ? (int)ceil($total / $perPage) : 1;
        ?>
        <?php if ($pages > 1): ?>
          <nav class="mt-3" aria-label="Services pagination">
            <ul class="pagination pagination-sm">
              <?php for ($p = 1; $p <= $pages; $p++): ?>
                <li class="page-item <?= $p === $page ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/services?page=<?= $p ?>&q=<?= urlencode((string)($q ?? '')) ?>&status=<?= urlencode((string)($status ?? '')) ?>&department_id=<?= urlencode((string)($department_id ?? '')) ?>"><?= $p ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>






