<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Service Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
              <h2 class="h5 mb-0">Service Details</h2>
              <div>
                <a class="btn btn-outline-primary" href="<?= htmlspecialchars($base) ?>/services/edit?id=<?= urlencode((string)($service['id'] ?? 0)) ?>">Edit</a>
                <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/services">Back</a>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <table class="table table-bordered">
                  <tr>
                    <th width="40%">Service ID</th>
                    <td><?= (int)($service['id'] ?? 0) ?></td>
                  </tr>
                  <tr>
                    <th>Service Name</th>
                    <td><?= htmlspecialchars($service['name'] ?? '') ?></td>
                  </tr>
                  <tr>
                    <th>Service Code</th>
                    <td><?= htmlspecialchars($service['code'] ?? 'N/A') ?></td>
                  </tr>
                  <tr>
                    <th>Department</th>
                    <td><?= htmlspecialchars($service['department_name'] ?? 'N/A') ?></td>
                  </tr>
                  <tr>
                    <th>Price</th>
                    <td>₹<?= number_format((float)($service['price'] ?? 0), 2) ?></td>
                  </tr>
                  <tr>
                    <th>Status</th>
                    <td>
                      <?= ((isset($service['status']) && (int)$service['status'] === 1) ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>') ?>
                    </td>
                  </tr>
                </table>
              </div>
              <div class="col-md-6">
                <table class="table table-bordered">
                  <tr>
                    <th width="40%">Description</th>
                    <td><?= htmlspecialchars($service['description'] ?? 'N/A') ?></td>
                  </tr>
                  <tr>
                    <th>Created At</th>
                    <td><?= htmlspecialchars($service['created_at'] ?? 'N/A') ?></td>
                  </tr>
                  <tr>
                    <th>Updated At</th>
                    <td><?= htmlspecialchars($service['updated_at'] ?? 'N/A') ?></td>
                  </tr>
                </table>
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






