<?php declare(strict_types=1); ?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h1 class="h4 mb-1"><?= htmlspecialchars($title ?? 'Departments') ?></h1>
    <div class="text-muted">Manage hospital departments (master setup)</div>
  </div>
  <div>
    <a href="<?= htmlspecialchars($base) ?>/settings" class="btn btn-secondary">Back to Settings</a>
    <a href="<?= htmlspecialchars($base) ?>/departments/add" class="btn btn-primary ms-2">Add Department</a>
  </div>
</div>

<div class="card card-elevated">
  <div class="card-body">
    <?php if (empty($departments)): ?>
      <div class="text-muted">No departments configured yet.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th>#</th>
              <th>Name</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($departments as $d): ?>
              <tr>
                <td><?= (int)($d['id'] ?? 0) ?></td>
                <td><?= htmlspecialchars($d['name'] ?? '') ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>
