<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Add Staff') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <h2 class="h5 mb-0"><i class="fas fa-user-plus me-2"></i>Add New Staff Member</h2>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? null;
              $formErrors = $_SESSION['form_errors'] ?? [];
              $old = $_SESSION['old'] ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base ?? '') ?>/staff/store">
              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label fw-semibold">Employee ID <span class="text-danger">*</span></label>
                  <input name="employee_id" value="<?= htmlspecialchars($old['employee_id'] ?? $employeeId ?? '') ?>" class="form-control form-control-lg" required />
                  <?php if (!empty($formErrors['employee_id'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['employee_id']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">First Name <span class="text-danger">*</span></label>
                  <input name="first_name" value="<?= htmlspecialchars($old['first_name'] ?? '') ?>" class="form-control form-control-lg" required />
                  <?php if (!empty($formErrors['first_name'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['first_name']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Last Name <span class="text-danger">*</span></label>
                  <input name="last_name" value="<?= htmlspecialchars($old['last_name'] ?? '') ?>" class="form-control form-control-lg" required />
                  <?php if (!empty($formErrors['last_name'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['last_name']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="row">
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Gender</label>
                  <select name="gender" class="form-select form-select-lg">
                    <option value="">-- Select --</option>
                    <option value="Male" <?= (isset($old['gender']) && $old['gender'] === 'Male') ? 'selected' : '' ?>>Male</option>
                    <option value="Female" <?= (isset($old['gender']) && $old['gender'] === 'Female') ? 'selected' : '' ?>>Female</option>
                    <option value="Other" <?= (isset($old['gender']) && $old['gender'] === 'Other') ? 'selected' : '' ?>>Other</option>
                  </select>
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Date of Birth</label>
                  <input type="date" name="dob" value="<?= htmlspecialchars($old['dob'] ?? '') ?>" class="form-control form-control-lg" />
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Phone</label>
                  <input type="tel" name="phone" value="<?= htmlspecialchars($old['phone'] ?? '') ?>" class="form-control form-control-lg" />
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Email</label>
                  <input type="email" name="email" value="<?= htmlspecialchars($old['email'] ?? '') ?>" class="form-control form-control-lg" />
                  <?php if (!empty($formErrors['email'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['email']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label fw-semibold">Department</label>
                  <select name="department_id" class="form-select form-select-lg">
                    <option value="">-- Select Department --</option>
                    <?php foreach (($departments ?? []) as $dept): ?>
                      <option value="<?= (int)$dept['id'] ?>" <?= (isset($old['department_id']) && (int)$old['department_id'] === (int)$dept['id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($dept['name']) ?>
                      </option>
                    <?php endforeach; ?>
                  </select>
                </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label fw-semibold">Designation</label>
                  <input name="designation" value="<?= htmlspecialchars($old['designation'] ?? '') ?>" class="form-control form-control-lg" placeholder="e.g., Nurse, Receptionist, Admin" />
                </div>
              </div>

              <div class="row">
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Joining Date</label>
                  <input type="date" name="joining_date" value="<?= htmlspecialchars($old['joining_date'] ?? '') ?>" class="form-control form-control-lg" />
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Salary (₹)</label>
                  <input type="number" name="salary" value="<?= htmlspecialchars($old['salary'] ?? '0.00') ?>" step="0.01" min="0" class="form-control form-control-lg" />
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Shift</label>
                  <select name="shift" class="form-select form-select-lg">
                    <option value="General" <?= (!isset($old['shift']) || $old['shift'] === 'General') ? 'selected' : '' ?>>General</option>
                    <option value="Morning" <?= (isset($old['shift']) && $old['shift'] === 'Morning') ? 'selected' : '' ?>>Morning</option>
                    <option value="Evening" <?= (isset($old['shift']) && $old['shift'] === 'Evening') ? 'selected' : '' ?>>Evening</option>
                    <option value="Night" <?= (isset($old['shift']) && $old['shift'] === 'Night') ? 'selected' : '' ?>>Night</option>
                  </select>
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label fw-semibold">Status</label>
                  <select name="status" class="form-select form-select-lg">
                    <option value="1" <?= (!isset($old['status']) || (int)$old['status'] === 1) ? 'selected' : '' ?>>Active</option>
                    <option value="0" <?= (isset($old['status']) && (int)$old['status'] === 0) ? 'selected' : '' ?>>Inactive</option>
                  </select>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label fw-semibold">Address</label>
                <textarea name="address" class="form-control" rows="3"><?= htmlspecialchars($old['address'] ?? '') ?></textarea>
              </div>

              <div class="d-flex justify-content-end gap-2 mt-4">
                <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/staff">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button class="btn btn-primary btn-lg" type="submit">
                  <i class="fas fa-save me-2"></i>Save Staff
                </button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

