<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .staff-card {
      transition: transform 0.2s, box-shadow 0.2s;
      border-left: 4px solid #0d6efd;
    }
    .staff-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .filter-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-users text-primary me-2"></i>Staff Management</h1>
            <p class="text-muted mb-0">Manage hospital staff members and their information</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/staff/add" class="btn btn-primary btn-lg shadow-sm">
              <i class="fas fa-plus-circle me-2"></i>Add New Staff
            </a>
            <a href="<?= htmlspecialchars($base) ?>/attendance" class="btn btn-success btn-lg shadow-sm ms-2">
              <i class="fas fa-calendar-check me-2"></i>Attendance
            </a>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/staff" class="row g-3">
              <div class="col-md-4">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search by name, employee ID, email..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-building me-2"></i>Department</label>
                <select name="department_id" class="form-select form-select-lg">
                  <option value="">All Departments</option>
                  <?php foreach (($departments ?? []) as $dept): ?>
                    <option value="<?= (int)$dept['id'] ?>" <?= (isset($department_id) && (int)$department_id === (int)$dept['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($dept['name']) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-toggle-on me-2"></i>Status</label>
                <select name="status" class="form-select form-select-lg">
                  <option value="">All</option>
                  <option value="1" <?= (isset($status) && $status === 1) ? 'selected' : '' ?>>Active</option>
                  <option value="0" <?= (isset($status) && $status === 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
              </div>
              <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Staff Table -->
        <div class="card shadow-sm border-0">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>Employee ID</th>
                    <th>Name</th>
                    <th>Designation</th>
                    <th>Department</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Shift</th>
                    <th>Status</th>
                    <th class="text-center">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($staff)): ?>
                    <?php foreach ($staff as $s): ?>
                      <tr>
                        <td><strong class="text-primary"><?= htmlspecialchars($s['employee_id'] ?? '') ?></strong></td>
                        <td>
                          <strong><?= htmlspecialchars(($s['first_name'] ?? '') . ' ' . ($s['last_name'] ?? '')) ?></strong>
                        </td>
                        <td><?= htmlspecialchars($s['designation'] ?? 'N/A') ?></td>
                        <td><?= htmlspecialchars($s['department_name'] ?? 'N/A') ?></td>
                        <td><?= htmlspecialchars($s['phone'] ?? 'N/A') ?></td>
                        <td><?= htmlspecialchars($s['email'] ?? 'N/A') ?></td>
                        <td><span class="badge bg-info"><?= htmlspecialchars($s['shift'] ?? 'General') ?></span></td>
                        <td>
                          <span class="badge bg-<?= ((isset($s['status']) && (int)$s['status'] === 1) ? 'success' : 'secondary') ?>">
                            <?= ((isset($s['status']) && (int)$s['status'] === 1) ? 'Active' : 'Inactive') ?>
                          </span>
                        </td>
                        <td class="text-center">
                          <div class="btn-group" role="group">
                            <a href="<?= htmlspecialchars($base) ?>/staff/view?id=<?= urlencode((string)($s['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-primary" title="View">
                              <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?= htmlspecialchars($base) ?>/staff/edit?id=<?= urlencode((string)($s['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-secondary" title="Edit">
                              <i class="fas fa-edit"></i>
                            </a>
                            <?php if (isset($s['status']) && (int)$s['status'] === 1): ?>
                              <form method="post" action="<?= htmlspecialchars($base) ?>/staff/deactivate" style="display:inline-block" onsubmit="return confirm('Deactivate this staff member?');">
                                <input type="hidden" name="id" value="<?= (int)($s['id'] ?? 0) ?>">
                                <button type="submit" class="btn btn-sm btn-outline-warning" title="Deactivate">
                                  <i class="fas fa-ban"></i>
                                </button>
                              </form>
                            <?php else: ?>
                              <form method="post" action="<?= htmlspecialchars($base) ?>/staff/restore" style="display:inline-block" onsubmit="return confirm('Restore this staff member?');">
                                <input type="hidden" name="id" value="<?= (int)($s['id'] ?? 0) ?>">
                                <button type="submit" class="btn btn-sm btn-outline-success" title="Restore">
                                  <i class="fas fa-check"></i>
                                </button>
                              </form>
                            <?php endif; ?>
                          </div>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="9" class="text-center text-muted py-5">
                        <i class="fas fa-users fa-3x d-block mb-3"></i>
                        <h5>No staff found</h5>
                        <p class="mb-0">Get started by adding your first staff member</p>
                        <a href="<?= htmlspecialchars($base) ?>/staff/add" class="btn btn-primary mt-3">
                          <i class="fas fa-plus-circle me-2"></i>Add New Staff
                        </a>
                      </td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Pagination -->
        <?php
          $total = (int)($total ?? 0);
          $perPage = (int)($perPage ?? 20);
          $page = (int)($page ?? 1);
          $pages = $perPage > 0 ? (int)ceil($total / $perPage) : 1;
        ?>
        <?php if ($pages > 1): ?>
          <nav class="mt-4" aria-label="Staff pagination">
            <ul class="pagination justify-content-center">
              <?php for ($p = 1; $p <= $pages; $p++): ?>
                <li class="page-item <?= $p === $page ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/staff?page=<?= $p ?>&q=<?= urlencode((string)($q ?? '')) ?>&status=<?= urlencode((string)($status ?? '')) ?>&department_id=<?= urlencode((string)($department_id ?? '')) ?>"><?= $p ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>






