<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Staff Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-user text-primary me-2"></i>Staff Details</h1>
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= htmlspecialchars($base) ?>/staff">Staff Management</a></li>
                <li class="breadcrumb-item active">Details</li>
              </ol>
            </nav>
          </div>
          <div>
            <a class="btn btn-outline-primary" href="<?= htmlspecialchars($base) ?>/staff/edit?id=<?= urlencode((string)($staff['id'] ?? 0)) ?>">
              <i class="fas fa-edit me-2"></i>Edit
            </a>
            <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/staff">
              <i class="fas fa-arrow-left me-2"></i>Back
            </a>
          </div>
        </div>

        <div class="row g-4">
          <div class="col-md-6">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Personal Information</h5>
              </div>
              <div class="card-body">
                <table class="table table-borderless mb-0">
                  <tr><th width="40%">Employee ID</th><td><strong class="text-primary"><?= htmlspecialchars($staff['employee_id'] ?? '') ?></strong></td></tr>
                  <tr><th>Name</th><td><?= htmlspecialchars(($staff['first_name'] ?? '') . ' ' . ($staff['last_name'] ?? '')) ?></td></tr>
                  <tr><th>Gender</th><td><?= htmlspecialchars($staff['gender'] ?? 'N/A') ?></td></tr>
                  <tr><th>Date of Birth</th><td><?= !empty($staff['dob']) ? date('d-m-Y', strtotime($staff['dob'])) : 'N/A' ?></td></tr>
                  <tr><th>Phone</th><td><?= htmlspecialchars($staff['phone'] ?? 'N/A') ?></td></tr>
                  <tr><th>Email</th><td><?= htmlspecialchars($staff['email'] ?? 'N/A') ?></td></tr>
                  <tr><th>Address</th><td><?= !empty($staff['address']) ? nl2br(htmlspecialchars($staff['address'])) : 'N/A' ?></td></tr>
                </table>
              </div>
            </div>
          </div>

          <div class="col-md-6">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-briefcase me-2"></i>Employment Information</h5>
              </div>
              <div class="card-body">
                <table class="table table-borderless mb-0">
                  <tr><th width="40%">Department</th><td><?= htmlspecialchars($staff['department_name'] ?? 'N/A') ?></td></tr>
                  <tr><th>Designation</th><td><?= htmlspecialchars($staff['designation'] ?? 'N/A') ?></td></tr>
                  <tr><th>Joining Date</th><td><?= !empty($staff['joining_date']) ? date('d-m-Y', strtotime($staff['joining_date'])) : 'N/A' ?></td></tr>
                  <tr><th>Salary</th><td><strong class="text-success">₹<?= number_format((float)($staff['salary'] ?? 0), 2) ?></strong></td></tr>
                  <tr><th>Shift</th><td><span class="badge bg-info"><?= htmlspecialchars($staff['shift'] ?? 'General') ?></span></td></tr>
                  <tr><th>Status</th><td><span class="badge bg-<?= ((isset($staff['status']) && (int)$staff['status'] === 1) ? 'success' : 'secondary') ?>"><?= ((isset($staff['status']) && (int)$staff['status'] === 1) ? 'Active' : 'Inactive') ?></span></td></tr>
                </table>
              </div>
            </div>
          </div>

          <?php if (!empty($attendance)): ?>
            <div class="col-12">
              <div class="card shadow-sm border-0">
                <div class="card-header bg-light">
                  <h5 class="mb-0"><i class="fas fa-calendar-check me-2"></i>Recent Attendance (This Month)</h5>
                </div>
                <div class="card-body p-0">
                  <div class="table-responsive">
                    <table class="table table-hover mb-0">
                      <thead class="table-light">
                        <tr>
                          <th>Date</th>
                          <th>Check In</th>
                          <th>Check Out</th>
                          <th>Status</th>
                          <th>Remarks</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ($attendance as $att): ?>
                          <tr>
                            <td><?= date('d-m-Y', strtotime($att['attendance_date'])) ?></td>
                            <td><?= !empty($att['check_in']) ? date('H:i', strtotime($att['check_in'])) : '-' ?></td>
                            <td><?= !empty($att['check_out']) ? date('H:i', strtotime($att['check_out'])) : '-' ?></td>
                            <td><span class="badge bg-<?= $att['status'] === 'Present' ? 'success' : ($att['status'] === 'Absent' ? 'danger' : 'warning') ?>"><?= htmlspecialchars($att['status']) ?></span></td>
                            <td><?= htmlspecialchars($att['remarks'] ?? '-') ?></td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






