// Admin scripts

(function () {
  function setActiveSidebarItem() {
    var sidebar = document.getElementById('sidebar');
    if (!sidebar) return;
    var links = sidebar.querySelectorAll('a.nav-item[href]');
    var currentPath = window.location.pathname;
    links.forEach(function (a) {
      try {
        var hrefPath = new URL(a.href, window.location.origin).pathname;
        if (hrefPath === '/' || hrefPath === '#') return;
        if (currentPath === hrefPath || currentPath.startsWith(hrefPath + '/')) {
          a.classList.add('active');
        }
      } catch (e) {
        /* ignore */
      }
    });
  }

  function applySidebarStateFromStorage() {
    var sidebar = document.getElementById('sidebar');
    if (!sidebar) return;
    var hidden = localStorage.getItem('admin.sidebar.hidden') === '1';
    if (hidden) {
      sidebar.classList.add('hidden');
    } else {
      sidebar.classList.remove('hidden');
    }
  }

  function initSidebarTogglePersistence() {
    var sidebar = document.getElementById('sidebar');
    if (!sidebar) return;
    document.addEventListener('click', function (e) {
      var btn = e.target.closest('#toggleSidebar');
      if (!btn) return;
      var hidden = sidebar.classList.toggle('hidden');
      localStorage.setItem('admin.sidebar.hidden', hidden ? '1' : '0');
    });
  }

  document.addEventListener('DOMContentLoaded', function () {
    applySidebarStateFromStorage();
    setActiveSidebarItem();
    initSidebarTogglePersistence();
  });
})();
