<?php
/**
 * Quick Script to Create Super Admin User
 * Run this once: http://localhost/hms_project/create_superadmin.php
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');

// Database configuration
$dbHost = '127.0.0.1';
$dbPort = '3306';
$dbUser = 'root';
$dbPass = '';
$dbName = 'hms';

echo "<h2>Create Super Admin User</h2>";
echo "<pre>";

try {
    // Connect to database
    $pdo = new PDO(
        "mysql:host={$dbHost};port={$dbPort};dbname={$dbName};charset=utf8mb4",
        $dbUser,
        $dbPass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
    echo "✓ Connected to database\n\n";

    // Check if super admin already exists
    $stmt = $pdo->prepare("SELECT id, email, role FROM admins WHERE email = ? AND role = ?");
    $stmt->execute(['superadmin@hms.local', 'super_admin']);
    $existing = $stmt->fetch();

    if ($existing) {
        echo "ℹ Super admin already exists:\n";
        echo "   ID: {$existing['id']}\n";
        echo "   Email: {$existing['email']}\n";
        echo "   Role: {$existing['role']}\n\n";
        echo "You can login with:\n";
        echo "   Email: superadmin@hms.local\n";
        echo "   Password: password\n";
    } else {
        // Create super admin
        $password = 'password';
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("
            INSERT INTO admins (name, email, role, hospital_id, password_hash, created_at) 
            VALUES (:name, :email, :role, NULL, :password_hash, NOW())
        ");
        $stmt->execute([
            ':name' => 'Super Administrator',
            ':email' => 'superadmin@hms.local',
            ':role' => 'super_admin',
            ':password_hash' => $passwordHash,
        ]);
        
        $id = $pdo->lastInsertId();
        echo "✓ Super admin created successfully!\n\n";
        echo "Login Credentials:\n";
        echo "   Email: superadmin@hms.local\n";
        echo "   Password: password\n";
        echo "   User ID: {$id}\n\n";
    }
    
    echo "========================================\n";
    echo "✓ Process completed!\n";
    echo "========================================\n";
    echo "\n";
    echo "Now you can login at:\n";
    echo "http://localhost/hms_project/superadmin/login\n";
    
} catch (PDOException $e) {
    echo "\n";
    echo "========================================\n";
    echo "✗ Error occurred!\n";
    echo "========================================\n";
    echo "Error: " . $e->getMessage() . "\n";
    echo "\n";
    echo "Please check:\n";
    echo "1. Database '{$dbName}' exists\n";
    echo "2. 'admins' table exists\n";
    echo "3. Database credentials are correct\n";
    exit(1);
} catch (Exception $e) {
    echo "\n";
    echo "========================================\n";
    echo "✗ Error occurred!\n";
    echo "========================================\n";
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}

echo "</pre>";
?>

