<?php
/**
 * Create Super Admin User
 * This script will create a super admin user and display credentials
 * Run: http://localhost/hms_project/create_superadmin_user.php
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');

// Database configuration
$dbHost = '127.0.0.1';
$dbPort = '3306';
$dbUser = 'root';
$dbPass = '';
$dbName = 'hms';

echo "<!DOCTYPE html>
<html lang='en'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Create Super Admin User</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css' rel='stylesheet'>
    <style>
        body { background: #f5f5f5; padding: 20px; }
        .card { max-width: 600px; margin: 0 auto; }
        .credentials { background: #e7f3ff; padding: 20px; border-radius: 8px; margin: 20px 0; }
        .cred-box { background: white; padding: 15px; border-radius: 5px; margin: 10px 0; border-left: 4px solid #0d6efd; }
    </style>
</head>
<body>";

echo "<div class='container'>
    <div class='card shadow-lg'>
        <div class='card-header bg-primary text-white'>
            <h3 class='mb-0'><i class='fas fa-user-shield'></i> Create Super Admin User</h3>
        </div>
        <div class='card-body'>";

try {
    // Connect to database
    $pdo = new PDO(
        "mysql:host={$dbHost};port={$dbPort};dbname={$dbName};charset=utf8mb4",
        $dbUser,
        $dbPass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
    
    echo "<div class='alert alert-success'><i class='fas fa-check-circle'></i> Database connected successfully!</div>";

    // Check if admins table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'admins'");
    if ($stmt->rowCount() === 0) {
        echo "<div class='alert alert-danger'>
            <strong>Error:</strong> 'admins' table does not exist!<br>
            Please run <code>setup_database.php</code> first.
        </div>";
        echo "</div></div></div></body></html>";
        exit;
    }

    $email = 'superadmin@hms.local';
    $password = 'password';
    
    // Check if user already exists
    $stmt = $pdo->prepare("SELECT id, name, email, role, hospital_id, created_at FROM admins WHERE email = ?");
    $stmt->execute([$email]);
    $existingUser = $stmt->fetch();
    
    if ($existingUser) {
        echo "<div class='alert alert-warning'>
            <strong>Info:</strong> Super admin user already exists!
        </div>";
        
        // Update password to ensure it works
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE admins SET password_hash = ?, role = 'super_admin', hospital_id = NULL WHERE email = ?");
        $stmt->execute([$passwordHash, $email]);
        
        echo "<div class='alert alert-info'>
            <strong>Updated:</strong> Password has been reset and role verified.
        </div>";
        
        $userId = $existingUser['id'];
        $userName = $existingUser['name'];
        
    } else {
        // Create new super admin user
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("
            INSERT INTO admins (name, email, role, hospital_id, password_hash, created_at) 
            VALUES (:name, :email, :role, NULL, :password_hash, NOW())
        ");
        $stmt->execute([
            ':name' => 'Super Administrator',
            ':email' => $email,
            ':role' => 'super_admin',
            ':password_hash' => $passwordHash,
        ]);
        
        $userId = $pdo->lastInsertId();
        $userName = 'Super Administrator';
        
        echo "<div class='alert alert-success'>
            <strong>Success:</strong> Super admin user created successfully!
        </div>";
    }
    
    // Verify password
    $stmt = $pdo->prepare("SELECT password_hash FROM admins WHERE id = ?");
    $stmt->execute([$userId]);
    $verifyUser = $stmt->fetch();
    
    $passwordVerified = password_verify($password, $verifyUser['password_hash']);
    
    // Display credentials
    echo "<div class='credentials'>
        <h4 class='text-primary mb-3'><i class='fas fa-key'></i> Login Credentials</h4>
        
        <div class='cred-box'>
            <strong><i class='fas fa-id-card'></i> User ID:</strong><br>
            <code style='font-size: 18px; color: #0d6efd;'>{$userId}</code>
        </div>
        
        <div class='cred-box'>
            <strong><i class='fas fa-envelope'></i> Email:</strong><br>
            <code style='font-size: 18px; color: #0d6efd;'>{$email}</code>
        </div>
        
        <div class='cred-box'>
            <strong><i class='fas fa-lock'></i> Password:</strong><br>
            <code style='font-size: 18px; color: #0d6efd;'>{$password}</code>
        </div>
        
        <div class='cred-box'>
            <strong><i class='fas fa-user-tag'></i> Role:</strong><br>
            <span class='badge bg-success' style='font-size: 14px; padding: 8px;'>super_admin</span>
        </div>
        
        <div class='cred-box'>
            <strong><i class='fas fa-user'></i> Name:</strong><br>
            <span style='font-size: 16px;'>{$userName}</span>
        </div>";
    
    if ($passwordVerified) {
        echo "<div class='alert alert-success mt-3'>
            <i class='fas fa-check-circle'></i> Password verification: <strong>SUCCESS</strong>
        </div>";
    } else {
        echo "<div class='alert alert-danger mt-3'>
            <i class='fas fa-exclamation-triangle'></i> Password verification: <strong>FAILED</strong>
        </div>";
    }
    
    echo "</div>";
    
    // Login information
    echo "<div class='alert alert-info'>
        <h5><i class='fas fa-sign-in-alt'></i> Login Information:</h5>
        <p class='mb-2'><strong>Login URL:</strong></p>
        <p><a href='http://localhost/hms_project/superadmin/login' target='_blank' class='btn btn-primary'>
            http://localhost/hms_project/superadmin/login
        </a></p>
    </div>";
    
    // Summary table
    echo "<div class='table-responsive'>
        <table class='table table-bordered'>
            <thead class='table-primary'>
                <tr>
                    <th>Field</th>
                    <th>Value</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><strong>User ID</strong></td>
                    <td><code>{$userId}</code></td>
                </tr>
                <tr>
                    <td><strong>Name</strong></td>
                    <td>{$userName}</td>
                </tr>
                <tr>
                    <td><strong>Email</strong></td>
                    <td><code>{$email}</code></td>
                </tr>
                <tr>
                    <td><strong>Password</strong></td>
                    <td><code>{$password}</code></td>
                </tr>
                <tr>
                    <td><strong>Role</strong></td>
                    <td><span class='badge bg-success'>super_admin</span></td>
                </tr>
                <tr>
                    <td><strong>Hospital ID</strong></td>
                    <td><code>NULL</code> (Super Admin)</td>
                </tr>
                <tr>
                    <td><strong>Password Verified</strong></td>
                    <td>" . ($passwordVerified ? "<span class='badge bg-success'>Yes</span>" : "<span class='badge bg-danger'>No</span>") . "</td>
                </tr>
            </tbody>
        </table>
    </div>";
    
    echo "<div class='alert alert-warning mt-3'>
        <strong><i class='fas fa-exclamation-triangle'></i> Important:</strong><br>
        <ul class='mb-0'>
            <li>Save these credentials in a secure place</li>
            <li>Change the password after first login</li>
            <li>Do not share these credentials publicly</li>
            <li>Delete this file after use for security</li>
        </ul>
    </div>";
    
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>
        <strong>Database Error:</strong><br>
        " . htmlspecialchars($e->getMessage()) . "<br><br>
        <strong>Please check:</strong><br>
        <ul>
            <li>MySQL is running in XAMPP</li>
            <li>Database '{$dbName}' exists</li>
            <li>Database credentials are correct</li>
        </ul>
    </div>";
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>
        <strong>Error:</strong> " . htmlspecialchars($e->getMessage()) . "
    </div>";
}

echo "</div></div></div>
<script src='https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js'></script>
</body></html>";
?>

