<?php
/**
 * Debug Login Issue
 * Run this to check what's happening with login
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');

// Database configuration
$dbHost = '127.0.0.1';
$dbPort = '3306';
$dbUser = 'root';
$dbPass = '';
$dbName = 'hms';

echo "<h2>Super Admin Login Debug</h2>";
echo "<pre>";

try {
    // Connect to database
    $pdo = new PDO(
        "mysql:host={$dbHost};port={$dbPort};dbname={$dbName};charset=utf8mb4",
        $dbUser,
        $dbPass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
    echo "✓ Database connected\n\n";

    // Check if admins table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'admins'");
    if ($stmt->rowCount() === 0) {
        echo "✗ ERROR: 'admins' table does not exist!\n";
        echo "Please run setup_database.php first\n";
        exit;
    }
    echo "✓ 'admins' table exists\n\n";

    // Check all admins
    echo "All Admin Users:\n";
    echo str_repeat("-", 80) . "\n";
    $stmt = $pdo->query("SELECT id, name, email, role, hospital_id, created_at FROM admins");
    $admins = $stmt->fetchAll();
    
    if (empty($admins)) {
        echo "✗ No admin users found!\n";
        echo "\nCreating super admin user...\n";
        
        $password = 'password';
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("
            INSERT INTO admins (name, email, role, hospital_id, password_hash, created_at) 
            VALUES (:name, :email, :role, NULL, :password_hash, NOW())
        ");
        $stmt->execute([
            ':name' => 'Super Administrator',
            ':email' => 'superadmin@hms.local',
            ':role' => 'super_admin',
            ':password_hash' => $passwordHash,
        ]);
        
        echo "✓ Super admin created!\n";
        echo "   Email: superadmin@hms.local\n";
        echo "   Password: password\n\n";
        
        // Fetch again
        $stmt = $pdo->query("SELECT id, name, email, role, hospital_id, created_at FROM admins");
        $admins = $stmt->fetchAll();
    }
    
    foreach ($admins as $admin) {
        echo sprintf(
            "ID: %d | Email: %s | Role: %s | Hospital ID: %s\n",
            $admin['id'],
            $admin['email'],
            $admin['role'],
            $admin['hospital_id'] ?? 'NULL'
        );
    }
    echo str_repeat("-", 80) . "\n\n";

    // Check specific super admin
    echo "Checking superadmin@hms.local:\n";
    $stmt = $pdo->prepare("SELECT id, name, email, role, hospital_id, password_hash FROM admins WHERE email = ?");
    $stmt->execute(['superadmin@hms.local']);
    $superAdmin = $stmt->fetch();
    
    if (!$superAdmin) {
        echo "✗ Super admin user NOT found!\n";
        echo "\nCreating super admin...\n";
        
        $password = 'password';
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("
            INSERT INTO admins (name, email, role, hospital_id, password_hash, created_at) 
            VALUES (:name, :email, :role, NULL, :password_hash, NOW())
        ");
        $stmt->execute([
            ':name' => 'Super Administrator',
            ':email' => 'superadmin@hms.local',
            ':role' => 'super_admin',
            ':password_hash' => $passwordHash,
        ]);
        
        echo "✓ Super admin created!\n";
    } else {
        echo "✓ Super admin found:\n";
        echo "   ID: {$superAdmin['id']}\n";
        echo "   Email: {$superAdmin['email']}\n";
        echo "   Role: {$superAdmin['role']}\n";
        echo "   Hospital ID: " . ($superAdmin['hospital_id'] ?? 'NULL') . "\n";
        
        // Test password
        $testPassword = 'password';
        if (password_verify($testPassword, $superAdmin['password_hash'])) {
            echo "   ✓ Password verification: SUCCESS\n";
        } else {
            echo "   ✗ Password verification: FAILED\n";
            echo "   Updating password...\n";
            
            $newHash = password_hash($testPassword, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE id = ?");
            $stmt->execute([$newHash, $superAdmin['id']]);
            echo "   ✓ Password updated!\n";
        }
    }
    
    echo "\n";
    echo "========================================\n";
    echo "Login Credentials:\n";
    echo "========================================\n";
    echo "Email: superadmin@hms.local\n";
    echo "Password: password\n";
    echo "\nLogin URL: http://localhost/hms_project/superadmin/login\n";
    
} catch (PDOException $e) {
    echo "\n";
    echo "========================================\n";
    echo "✗ Database Error!\n";
    echo "========================================\n";
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}

echo "</pre>";
?>

