<?php
/**
 * Script to add hospital_id column to patients table if it doesn't exist
 */

require __DIR__ . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'database.php';

try {
    $pdo = new PDO(
        "mysql:host={$dbConfig['host']};dbname={$dbConfig['dbname']};charset=utf8mb4",
        $dbConfig['user'],
        $dbConfig['pass'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    echo "Checking patients table for hospital_id column...\n\n";

    // Check if hospital_id column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM patients LIKE 'hospital_id'");
    $exists = $stmt->fetch();

    if ($exists) {
        echo "✓ hospital_id column already exists in patients table\n";
    } else {
        echo "✗ hospital_id column NOT found. Adding it now...\n\n";

        // Check if hospitals table exists first
        $stmt = $pdo->query("SHOW TABLES LIKE 'hospitals'");
        $hospitalsTableExists = $stmt->fetch();

        if (!$hospitalsTableExists) {
            echo "✗ ERROR: hospitals table does not exist. Please run database.sql first.\n";
            exit(1);
        }

        // Add hospital_id column
        $sql = "ALTER TABLE `patients` 
                ADD COLUMN `hospital_id` INT UNSIGNED NULL AFTER `id`,
                ADD KEY `idx_patients_hospital` (`hospital_id`)";

        $pdo->exec($sql);
        echo "✓ Added hospital_id column\n";

        // Try to add foreign key constraint
        try {
            $pdo->exec("ALTER TABLE `patients` 
                       ADD CONSTRAINT `fk_patients_hospital` 
                       FOREIGN KEY (`hospital_id`) 
                       REFERENCES `hospitals` (`id`) 
                       ON DELETE CASCADE");
            echo "✓ Added foreign key constraint\n";
        } catch (PDOException $e) {
            echo "⚠ Could not add foreign key constraint (may already exist): " . $e->getMessage() . "\n";
        }

        echo "\n✓ Successfully added hospital_id column to patients table!\n";
    }

    // Verify the column
    $stmt = $pdo->query("SHOW COLUMNS FROM patients");
    $columns = $stmt->fetchAll();
    echo "\nCurrent columns in patients table:\n";
    foreach ($columns as $col) {
        echo "  - {$col['Field']} ({$col['Type']})\n";
    }

} catch (PDOException $e) {
    echo "✗ Database Error: " . $e->getMessage() . "\n";
    exit(1);
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}

