-- Script to add hospital_id column to patients table if it doesn't exist
-- Run this in phpMyAdmin or MySQL command line

USE `hms`;

-- Check if hospital_id column exists, if not add it
-- Run this in MySQL 8.0+ or phpMyAdmin

-- Step 1: Add hospital_id column if it doesn't exist
SET @dbname = DATABASE();
SET @tablename = "patients";
SET @columnname = "hospital_id";
SET @preparedStatement = (SELECT IF(
  (
    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE
      (TABLE_SCHEMA = @dbname)
      AND (TABLE_NAME = @tablename)
      AND (COLUMN_NAME = @columnname)
  ) > 0,
  "SELECT 'Column already exists' AS result;",
  CONCAT("ALTER TABLE `", @tablename, "` ADD COLUMN `", @columnname, "` INT UNSIGNED NULL AFTER `id`;")
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Step 2: Add index if it doesn't exist
-- Note: This will fail if index already exists, that's OK
ALTER TABLE `patients` ADD INDEX `idx_patients_hospital` (`hospital_id`);

-- Step 3: Add foreign key constraint if it doesn't exist
-- Note: This will fail if constraint already exists, that's OK
ALTER TABLE `patients` 
ADD CONSTRAINT `fk_patients_hospital` 
FOREIGN KEY (`hospital_id`) 
REFERENCES `hospitals` (`id`) 
ON DELETE CASCADE;

-- Verify the column was added
SHOW COLUMNS FROM `patients`;

