<?php
/**
 * Simple script to add hospital_id column to patients table
 * Run this via browser: http://localhost/hms_project/fix_patients_hospital_id_simple.php
 */

// Load database configuration
$dbConfigFile = __DIR__ . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'database.php';
$dbConfig = require $dbConfigFile;

// Extract connection details
$host = '127.0.0.1';
$dbname = 'hms';
$user = $dbConfig['user'] ?? 'root';
$pass = $dbConfig['pass'] ?? '';

echo "<h2>Fixing patients table - Adding hospital_id column</h2>";
echo "<pre>";

try {
    $pdo = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $user,
        $pass,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "✓ Connected to database '$dbname'\n\n";

    // Check if column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM patients LIKE 'hospital_id'");
    $exists = $stmt->fetch();

    if ($exists) {
        echo "✓ hospital_id column already exists in patients table\n";
    } else {
        echo "✗ hospital_id column NOT found. Adding it now...\n\n";

        // Check if hospitals table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'hospitals'");
        if (!$stmt->fetch()) {
            echo "✗ ERROR: hospitals table does not exist. Please run database.sql first.\n";
            exit;
        }

        // Add column
        $pdo->exec("ALTER TABLE `patients` ADD COLUMN `hospital_id` INT UNSIGNED NULL AFTER `id`");
        echo "✓ Added hospital_id column\n";

        // Add index
        try {
            $pdo->exec("ALTER TABLE `patients` ADD INDEX `idx_patients_hospital` (`hospital_id`)");
            echo "✓ Added index\n";
        } catch (PDOException $e) {
            echo "⚠ Index may already exist (continuing...)\n";
        }

        // Add foreign key
        try {
            $pdo->exec("ALTER TABLE `patients` 
                       ADD CONSTRAINT `fk_patients_hospital` 
                       FOREIGN KEY (`hospital_id`) 
                       REFERENCES `hospitals` (`id`) 
                       ON DELETE CASCADE");
            echo "✓ Added foreign key constraint\n";
        } catch (PDOException $e) {
            echo "⚠ Foreign key may already exist (continuing...)\n";
        }

        echo "\n✓ SUCCESS! hospital_id column added to patients table!\n";
    }

    // Show current columns
    echo "\nCurrent columns in patients table:\n";
    $stmt = $pdo->query("SHOW COLUMNS FROM patients");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        echo "  - {$col['Field']} ({$col['Type']})\n";
    }

} catch (PDOException $e) {
    echo "✗ Database Error: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<p><a href='admin/'>Go to Admin Panel</a></p>";

