<?php
// Reuse admin database config
$adminConfigFile = dirname(__DIR__, 3) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'database.php';
if (file_exists($adminConfigFile)) {
    $adminConfig = require $adminConfigFile;
    // Convert to Model expected format
    if (isset($adminConfig['host'])) {
        return [
            'dsn' => "mysql:host={$adminConfig['host']};port=" . ($adminConfig['port'] ?? 3306) . ";dbname={$adminConfig['dbname']};charset=utf8mb4",
            'user' => $adminConfig['user'] ?? 'root',
            'pass' => $adminConfig['pass'] ?? '',
            'options' => [],
        ];
    }
    // Already in correct format
    return $adminConfig;
}

// Fallback config
return [
    'dsn' => 'mysql:host=127.0.0.1;port=3306;dbname=hms;charset=utf8mb4',
    'user' => 'root',
    'pass' => '',
    'options' => [],
];

