<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
<body class="bg-light" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center;">
  <div class="container d-flex align-items-center justify-content-center">
    <div class="card shadow-xl border-0" style="width: 100%; max-width: 420px; border-radius: 1rem;">
      <div class="card-body p-5">
        <div class="text-center mb-4">
          <div class="mb-3">
            <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-primary bg-gradient" style="width: 64px; height: 64px; box-shadow: 0 10px 25px rgba(37, 99, 235, 0.3);">
              <i class="fas fa-shield-alt fa-2x text-white"></i>
            </div>
          </div>
          <h2 class="h3 fw-bold text-gradient mb-2">Super Admin Panel</h2>
          <p class="text-muted mb-0">Multi-Hospital Management System</p>
        </div>
        
        <?php if (!empty($error ?? null)): ?>
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($error) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>
        
        <form method="post" action="<?= htmlspecialchars($base ?? '') ?>/auth/login">
          <div class="mb-3">
            <label class="form-label fw-semibold">Email</label>
            <input type="email" name="email" class="form-control form-control-lg" required autofocus value="superadmin@hms.local" placeholder="superadmin@hms.local">
          </div>
          <div class="mb-3">
            <label class="form-label fw-semibold">Password</label>
            <input type="password" name="password" class="form-control form-control-lg" required placeholder="password">
          </div>
          <button type="submit" class="btn btn-primary btn-lg w-100 shadow-md" style="padding: 0.75rem;">
            <i class="fas fa-sign-in-alt me-2"></i>Login to Dashboard
          </button>
        </form>
        
        <div class="text-center mt-4">
          <small class="text-muted">
            Default: superadmin@hms.local / password
          </small>
        </div>
      </div>
    </div>
  </div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

