<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php';
?>
<div class="main-content">
<div class="container-fluid py-4">
  <div class="page-header mb-4">
    <h1 class="page-title">
      <i class="fas fa-tachometer-alt text-primary"></i>
      <span>Dashboard Overview</span>
    </h1>
    <p class="page-subtitle">Monitor and manage all hospitals from a single dashboard</p>
  </div>

  <!-- Overall Stats Cards -->
  <div class="row g-4 mb-4">
    <div class="col-md-3">
      <div class="card stat-card primary fade-in">
        <div class="card-body">
          <div class="stat-label">Total Hospitals</div>
          <div class="stat-value"><?= number_format((int)($totalHospitals ?? 0)) ?></div>
          <div class="stat-icon text-primary">
            <i class="fas fa-hospital"></i>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card stat-card success fade-in" style="animation-delay: 0.1s;">
        <div class="card-body">
          <div class="stat-label">Active Hospitals</div>
          <div class="stat-value"><?= number_format((int)($activeHospitals ?? 0)) ?></div>
          <div class="stat-icon text-success">
            <i class="fas fa-check-circle"></i>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card stat-card info fade-in" style="animation-delay: 0.2s;">
        <div class="card-body">
          <div class="stat-label">Total Patients</div>
          <div class="stat-value"><?= number_format((int)($overallStats['total_patients'] ?? 0)) ?></div>
          <div class="stat-icon text-info">
            <i class="fas fa-user-injured"></i>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card stat-card warning fade-in" style="animation-delay: 0.3s;">
        <div class="card-body">
          <div class="stat-label">Total Admins</div>
          <div class="stat-value"><?= number_format((int)($totalAdmins ?? 0)) ?></div>
          <div class="stat-icon text-warning">
            <i class="fas fa-users"></i>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Hospital-wise Statistics -->
  <div class="row mb-4">
    <div class="col-12">
      <div class="card shadow-md">
        <div class="card-header">
          <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-chart-bar me-2 text-primary"></i>Hospital-wise Statistics</h5>
            <small class="text-muted">Real-time data from each hospital panel</small>
          </div>
        </div>
        <div class="card-body">
          <?php if (!empty($hospitalStats ?? [])): ?>
          <div class="table-responsive">
            <table class="table table-hover align-middle">
              <thead>
                <tr>
                  <th>Hospital ID</th>
                  <th>Hospital Name</th>
                  <th>Code</th>
                  <th>Status</th>
                  <th class="text-center">
                    <i class="fas fa-user-injured me-1"></i>Patients
                  </th>
                  <th class="text-center">
                    <i class="fas fa-user-md me-1"></i>Doctors
                  </th>
                  <th class="text-center">
                    <i class="fas fa-calendar-check me-1"></i>Appointments
                  </th>
                  <th class="text-center">
                    <i class="fas fa-users me-1"></i>Admins
                  </th>
                  <th class="text-center">Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($hospitalStats as $item): 
                  $h = $item['hospital'];
                  $s = $item['stats'];
                  $patients = (int)($s['patients'] ?? 0);
                  $doctors = (int)($s['doctors'] ?? 0);
                  $appointments = (int)($s['appointments'] ?? 0);
                  $admins = (int)($s['admins'] ?? 0);
                ?>
                  <tr>
                    <td><span class="badge bg-dark">#<?= (int)$h['id'] ?></span></td>
                    <td>
                      <strong><?= htmlspecialchars($h['name'] ?? '') ?></strong>
                      <?php if (!empty($h['city'] ?? '')): ?>
                        <br><small class="text-muted"><?= htmlspecialchars($h['city']) ?></small>
                      <?php endif; ?>
                    </td>
                    <td><span class="badge bg-secondary"><?= htmlspecialchars($h['code'] ?? '') ?></span></td>
                    <td>
                      <span class="badge bg-<?= ($h['status'] ?? '') === 'Active' ? 'success' : (($h['status'] ?? '') === 'Suspended' ? 'danger' : 'secondary') ?>">
                        <?= htmlspecialchars($h['status'] ?? '') ?>
                      </span>
                    </td>
                    <td class="text-center">
                      <span class="badge bg-info fs-6 px-3 py-2">
                        <?= number_format($patients) ?>
                      </span>
                    </td>
                    <td class="text-center">
                      <span class="badge bg-primary fs-6 px-3 py-2">
                        <?= number_format($doctors) ?>
                      </span>
                    </td>
                    <td class="text-center">
                      <span class="badge bg-warning text-dark fs-6 px-3 py-2">
                        <?= number_format($appointments) ?>
                      </span>
                    </td>
                    <td class="text-center">
                      <span class="badge bg-secondary fs-6 px-3 py-2">
                        <?= number_format($admins) ?>
                      </span>
                    </td>
                    <td class="text-center">
                      <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/view?id=<?= (int)$h['id'] ?>" class="btn btn-sm btn-outline-primary" title="View Details">
                        <i class="fas fa-eye"></i> View
                      </a>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <?php else: ?>
            <div class="text-center text-muted py-5">
              <i class="fas fa-hospital fa-3x mb-3"></i>
              <p>No hospitals found. Please add a hospital to see statistics.</p>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <!-- Recent Hospitals -->
  <div class="row">
    <div class="col-12">
      <div class="card shadow-md">
        <div class="card-header">
          <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-hospital me-2 text-primary"></i>Recent Hospitals</h5>
            <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals" class="btn btn-sm btn-primary">
              View All <i class="fas fa-arrow-right ms-1"></i>
            </a>
          </div>
        </div>
        <div class="card-body">
          <?php if (!empty($recentHospitals ?? [])): ?>
            <div class="table-responsive">
              <table class="table table-hover">
                <thead>
                  <tr>
                    <th>Hospital ID</th>
                    <th>Name</th>
                    <th>Code</th>
                    <th>City</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($recentHospitals as $hospital): ?>
                    <tr>
                      <td><span class="badge bg-dark">#<?= (int)$hospital['id'] ?></span></td>
                      <td><?= htmlspecialchars($hospital['name'] ?? '') ?></td>
                      <td><span class="badge bg-secondary"><?= htmlspecialchars($hospital['code'] ?? '') ?></span></td>
                      <td><?= htmlspecialchars($hospital['city'] ?? 'N/A') ?></td>
                      <td>
                        <span class="badge bg-<?= ($hospital['status'] ?? '') === 'Active' ? 'success' : 'secondary' ?>">
                          <?= htmlspecialchars($hospital['status'] ?? '') ?>
                        </span>
                      </td>
                      <td><?= date('Y-m-d', strtotime($hospital['created_at'] ?? 'now')) ?></td>
                      <td>
                        <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/view?id=<?= (int)$hospital['id'] ?>" class="btn btn-sm btn-outline-primary">
                          <i class="fas fa-eye"></i>
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center text-muted py-5">
              <i class="fas fa-hospital fa-3x mb-3"></i>
              <p>No hospitals found. <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/add">Create your first hospital</a></p>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

