<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php';
?>
<div class="main-content">
<div class="container-fluid py-4">
  <div class="row">
    <div class="col-12 col-lg-8 mx-auto">
      <div class="card shadow-md">
        <div class="card-header">
          <h4 class="mb-0"><i class="fas fa-user-edit me-2 text-primary"></i>Edit Hospital Admin</h4>
        </div>
        <div class="card-body p-4">
          <?php if (!empty($formError ?? null)): ?>
            <div class="alert alert-danger alert-dismissible fade show">
              <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          <?php endif; ?>

          <form method="post" action="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/update">
            <input type="hidden" name="id" value="<?= (int)($admin['id'] ?? 0) ?>">
            
            <div class="mb-3">
              <label class="form-label fw-semibold">Hospital <span class="text-danger">*</span></label>
              <select name="hospital_id" class="form-select" required>
                <option value="">-- Select Hospital --</option>
                <?php foreach (($hospitals ?? []) as $hosp): ?>
                  <option value="<?= (int)$hosp['id'] ?>" <?= ((int)($old['hospital_id'] ?? $admin['hospital_id'] ?? 0) === (int)$hosp['id']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($hosp['name'] ?? '') ?> (<?= htmlspecialchars($hosp['code'] ?? '') ?>)
                  </option>
                <?php endforeach; ?>
              </select>
              <?php if (!empty($formErrors['hospital_id'] ?? null)): ?>
                <div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['hospital_id']) ?></div>
              <?php endif; ?>
            </div>

            <div class="row">
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Name <span class="text-danger">*</span></label>
                <input type="text" name="name" class="form-control" required value="<?= htmlspecialchars($old['name'] ?? $admin['name'] ?? '') ?>">
                <?php if (!empty($formErrors['name'] ?? null)): ?>
                  <div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['name']) ?></div>
                <?php endif; ?>
              </div>
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Email <span class="text-danger">*</span></label>
                <input type="email" name="email" class="form-control" required value="<?= htmlspecialchars($old['email'] ?? $admin['email'] ?? '') ?>">
                <?php if (!empty($formErrors['email'] ?? null)): ?>
                  <div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['email']) ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="mb-3">
              <label class="form-label fw-semibold">New Password</label>
              <input type="password" name="password" class="form-control" minlength="6" placeholder="Leave blank to keep current password">
              <small class="text-muted">Only enter if you want to change the password</small>
              <?php if (!empty($formErrors['password'] ?? null)): ?>
                <div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['password']) ?></div>
              <?php endif; ?>
            </div>

            <div class="d-flex justify-content-end gap-2 mt-4">
              <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins" class="btn btn-secondary">Cancel</a>
              <button type="submit" class="btn btn-primary">
                <i class="fas fa-save me-2"></i>Update Admin
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

