<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php';
?>
<div class="main-content">
<div class="container-fluid py-4">
  <?php if (!empty($flashSuccess ?? null)): ?>
    <div class="alert alert-success alert-dismissible fade show">
      <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 fw-bold"><i class="fas fa-users me-2"></i>Hospital Admins</h1>
    <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/add" class="btn btn-primary">
      <i class="fas fa-plus me-2"></i>Add Hospital Admin
    </a>
  </div>

  <!-- Filters -->
  <div class="card shadow-md mb-4">
    <div class="card-body">
      <form method="get" class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Search</label>
          <div class="input-group">
            <span class="input-group-text bg-white"><i class="fas fa-search text-muted"></i></span>
            <input type="text" name="q" class="form-control" placeholder="Search by name, email..." value="<?= htmlspecialchars($q ?? '') ?>">
          </div>
        </div>
        <div class="col-md-4">
          <label class="form-label">Hospital</label>
          <select name="hospital_id" class="form-select">
            <option value="">All Hospitals</option>
            <?php foreach (($hospitals ?? []) as $hosp): ?>
              <option value="<?= (int)$hosp['id'] ?>" <?= (!empty($selectedHospital) && (int)$selectedHospital === (int)$hosp['id']) ? 'selected' : '' ?>>
                <?= htmlspecialchars($hosp['name'] ?? '') ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <button type="submit" class="btn btn-primary w-100">
            <i class="fas fa-search me-1"></i>Search
          </button>
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins" class="btn btn-outline-secondary w-100">Reset</a>
        </div>
      </form>
    </div>
  </div>

  <!-- Admins Table -->
  <div class="card shadow-md">
    <div class="card-body">
      <?php if (!empty($admins ?? [])): ?>
        <div class="table-responsive">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>User ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Hospital ID</th>
                <th>Hospital</th>
                <th>Role</th>
                <th>Created</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($admins as $admin): ?>
                <tr>
                  <td><span class="badge bg-dark">#<?= (int)$admin['id'] ?></span></td>
                  <td><strong><?= htmlspecialchars($admin['name'] ?? '') ?></strong></td>
                  <td><?= htmlspecialchars($admin['email'] ?? '') ?></td>
                  <td>
                    <?php if (!empty($admin['hospital_id'])): ?>
                      <span class="badge bg-primary">#<?= (int)$admin['hospital_id'] ?></span>
                    <?php else: ?>
                      <span class="text-muted">-</span>
                    <?php endif; ?>
                  </td>
                  <td>
                    <?php if (!empty($admin['hospital_name'])): ?>
                      <span class="badge bg-secondary"><?= htmlspecialchars($admin['hospital_name']) ?></span>
                    <?php else: ?>
                      <span class="text-muted">No Hospital</span>
                    <?php endif; ?>
                  </td>
                  <td><span class="badge bg-info"><?= htmlspecialchars($admin['role'] ?? 'admin') ?></span></td>
                  <td><?= date('Y-m-d', strtotime($admin['created_at'] ?? 'now')) ?></td>
                  <td>
                    <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/edit?id=<?= (int)$admin['id'] ?>" class="btn btn-sm btn-outline-info" title="Edit">
                      <i class="fas fa-edit"></i>
                    </a>
                    <?php if (!empty($admin['hospital_id'])): ?>
                      <a href="<?= str_replace('/superadmin', '/admin', htmlspecialchars($base ?? '')) ?>/login" target="_blank" class="btn btn-sm btn-outline-success" title="Open Hospital Panel">
                        <i class="fas fa-external-link-alt"></i>
                      </a>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        
        <!-- Pagination -->
        <?php if (($total ?? 0) > ($perPage ?? 20)): ?>
          <nav>
            <ul class="pagination justify-content-center">
              <?php
                $totalPages = ceil(($total ?? 0) / ($perPage ?? 20));
                $currentPage = $page ?? 1;
                for ($i = 1; $i <= $totalPages; $i++):
              ?>
                <li class="page-item <?= $i === $currentPage ? 'active' : '' ?>">
                  <a class="page-link" href="?page=<?= $i ?>&q=<?= urlencode($q ?? '') ?>&hospital_id=<?= urlencode((string)($selectedHospital ?? '')) ?>"><?= $i ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      <?php else: ?>
        <div class="text-center text-muted py-5">
          <i class="fas fa-users fa-3x mb-3"></i>
          <p>No hospital admins found. <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/add">Create your first hospital admin</a></p>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
</div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

