<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php';
?>
<div class="main-content">
<div class="container-fluid py-4">
  <div class="row">
    <div class="col-12 col-lg-8 mx-auto">
      <div class="card shadow-md">
        <div class="card-header">
          <h4 class="mb-0"><i class="fas fa-edit me-2 text-primary"></i>Edit Hospital</h4>
        </div>
        <div class="card-body p-4">
          <?php if (!empty($formError ?? null)): ?>
            <div class="alert alert-danger alert-dismissible fade show">
              <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          <?php endif; ?>

          <form method="post" action="<?= htmlspecialchars($base ?? '') ?>/hospitals/update">
            <input type="hidden" name="id" value="<?= (int)($hospital['id'] ?? 0) ?>">
            
            <div class="row">
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Hospital Name <span class="text-danger">*</span></label>
                <input type="text" name="name" class="form-control" required value="<?= htmlspecialchars($old['name'] ?? $hospital['name'] ?? '') ?>">
                <?php if (!empty($formErrors['name'] ?? null)): ?>
                  <div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['name']) ?></div>
                <?php endif; ?>
              </div>
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Hospital Code <span class="text-danger">*</span></label>
                <input type="text" name="code" class="form-control" required value="<?= htmlspecialchars($old['code'] ?? $hospital['code'] ?? '') ?>">
                <?php if (!empty($formErrors['code'] ?? null)): ?>
                  <div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['code']) ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="mb-3">
              <label class="form-label fw-semibold">Address</label>
              <textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($old['address'] ?? $hospital['address'] ?? '') ?></textarea>
            </div>

            <div class="row">
              <div class="col-md-4 mb-3">
                <label class="form-label fw-semibold">City</label>
                <input type="text" name="city" class="form-control" value="<?= htmlspecialchars($old['city'] ?? $hospital['city'] ?? '') ?>">
              </div>
              <div class="col-md-4 mb-3">
                <label class="form-label fw-semibold">State</label>
                <input type="text" name="state" class="form-control" value="<?= htmlspecialchars($old['state'] ?? $hospital['state'] ?? '') ?>">
              </div>
              <div class="col-md-4 mb-3">
                <label class="form-label fw-semibold">Pincode</label>
                <input type="text" name="pincode" class="form-control" value="<?= htmlspecialchars($old['pincode'] ?? $hospital['pincode'] ?? '') ?>">
              </div>
            </div>

            <div class="row">
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Phone</label>
                <input type="tel" name="phone" class="form-control" value="<?= htmlspecialchars($old['phone'] ?? $hospital['phone'] ?? '') ?>">
              </div>
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Email</label>
                <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($old['email'] ?? $hospital['email'] ?? '') ?>">
                <?php if (!empty($formErrors['email'] ?? null)): ?>
                  <div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['email']) ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Website</label>
                <input type="url" name="website" class="form-control" value="<?= htmlspecialchars($old['website'] ?? $hospital['website'] ?? '') ?>">
              </div>
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Status</label>
                <select name="status" class="form-select">
                  <option value="Active" <?= ($old['status'] ?? $hospital['status'] ?? 'Active') === 'Active' ? 'selected' : '' ?>>Active</option>
                  <option value="Inactive" <?= ($old['status'] ?? $hospital['status'] ?? '') === 'Inactive' ? 'selected' : '' ?>>Inactive</option>
                  <option value="Suspended" <?= ($old['status'] ?? $hospital['status'] ?? '') === 'Suspended' ? 'selected' : '' ?>>Suspended</option>
                </select>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Registration Number</label>
                <input type="text" name="registration_number" class="form-control" value="<?= htmlspecialchars($old['registration_number'] ?? $hospital['registration_number'] ?? '') ?>">
              </div>
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">License Number</label>
                <input type="text" name="license_number" class="form-control" value="<?= htmlspecialchars($old['license_number'] ?? $hospital['license_number'] ?? '') ?>">
              </div>
            </div>

            <div class="row">
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Subscription Plan</label>
                <select name="subscription_plan" class="form-select">
                  <option value="Basic" <?= ($old['subscription_plan'] ?? $hospital['subscription_plan'] ?? 'Basic') === 'Basic' ? 'selected' : '' ?>>Basic</option>
                  <option value="Premium" <?= ($old['subscription_plan'] ?? $hospital['subscription_plan'] ?? '') === 'Premium' ? 'selected' : '' ?>>Premium</option>
                  <option value="Enterprise" <?= ($old['subscription_plan'] ?? $hospital['subscription_plan'] ?? '') === 'Enterprise' ? 'selected' : '' ?>>Enterprise</option>
                </select>
              </div>
              <div class="col-md-6 mb-3">
                <label class="form-label fw-semibold">Max Users</label>
                <input type="number" name="max_users" class="form-control" value="<?= htmlspecialchars($old['max_users'] ?? $hospital['max_users'] ?? '10') ?>" min="1">
              </div>
            </div>

            <div class="d-flex justify-content-end gap-2 mt-4">
              <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/view?id=<?= (int)($hospital['id'] ?? 0) ?>" class="btn btn-secondary">Cancel</a>
              <button type="submit" class="btn btn-primary">
                <i class="fas fa-save me-2"></i>Update Hospital
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

