<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php';
?>
<div class="main-content">
<div class="container-fluid py-4">
  <?php if (!empty($flashSuccess ?? null)): ?>
    <div class="alert alert-success alert-dismissible fade show">
      <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <div class="page-header mb-4">
    <div class="d-flex justify-content-between align-items-start">
      <div>
        <h1 class="page-title">
          <i class="fas fa-hospital text-primary"></i>
          <span>Hospitals Management</span>
        </h1>
        <p class="page-subtitle">Manage all hospitals and their configurations</p>
      </div>
      <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/add" class="btn btn-primary btn-lg shadow-md">
        <i class="fas fa-plus"></i>
        <span>Add Hospital</span>
      </a>
    </div>
  </div>

  <!-- Filters -->
  <div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
      <form method="get" class="row g-3">
        <div class="col-md-4">
          <input type="text" name="q" class="form-control" placeholder="Search by name, code, city..." value="<?= htmlspecialchars($q ?? '') ?>">
        </div>
        <div class="col-md-3">
          <select name="status" class="form-select">
            <option value="">All Status</option>
            <option value="Active" <?= ($status ?? '') === 'Active' ? 'selected' : '' ?>>Active</option>
            <option value="Inactive" <?= ($status ?? '') === 'Inactive' ? 'selected' : '' ?>>Inactive</option>
            <option value="Suspended" <?= ($status ?? '') === 'Suspended' ? 'selected' : '' ?>>Suspended</option>
          </select>
        </div>
        <div class="col-md-2">
          <button type="submit" class="btn btn-outline-primary w-100">
            <i class="fas fa-search me-1"></i>Search
          </button>
        </div>
        <div class="col-md-2">
          <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals" class="btn btn-outline-secondary w-100">Reset</a>
        </div>
      </form>
    </div>
  </div>

  <!-- Hospitals Table -->
  <div class="card shadow-md">
    <div class="card-body">
      <?php if (!empty($hospitals ?? [])): ?>
        <div class="table-responsive">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Hospital ID</th>
                <th>Name</th>
                <th>Code</th>
                <th>City</th>
                <th>Phone</th>
                <th>Status</th>
                <th>Users</th>
                <th>Created</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($hospitals as $hospital): 
                // User count is already calculated in controller
                $userCount = (int)($hospital['user_count'] ?? 0);
              ?>
                <tr>
                  <td><span class="badge bg-dark">#<?= (int)$hospital['id'] ?></span></td>
                  <td><strong><?= htmlspecialchars($hospital['name'] ?? '') ?></strong></td>
                  <td><span class="badge bg-secondary"><?= htmlspecialchars($hospital['code'] ?? '') ?></span></td>
                  <td><?= htmlspecialchars($hospital['city'] ?? 'N/A') ?></td>
                  <td><?= htmlspecialchars($hospital['phone'] ?? 'N/A') ?></td>
                  <td>
                    <span class="badge bg-<?= ($hospital['status'] ?? '') === 'Active' ? 'success' : (($hospital['status'] ?? '') === 'Suspended' ? 'danger' : 'secondary') ?>">
                      <?= htmlspecialchars($hospital['status'] ?? '') ?>
                    </span>
                  </td>
                  <td><span class="badge bg-info"><?= $userCount ?> user(s)</span></td>
                  <td><?= date('Y-m-d', strtotime($hospital['created_at'] ?? 'now')) ?></td>
                  <td>
                    <div class="btn-group" role="group">
                      <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/view?id=<?= (int)$hospital['id'] ?>" class="btn btn-sm btn-outline-primary" title="View">
                        <i class="fas fa-eye"></i>
                      </a>
                      <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/edit?id=<?= (int)$hospital['id'] ?>" class="btn btn-sm btn-outline-info" title="Edit">
                        <i class="fas fa-edit"></i>
                      </a>
                      <button type="button" class="btn btn-sm btn-outline-danger" title="Delete" onclick="confirmDelete(<?= (int)$hospital['id'] ?>, '<?= htmlspecialchars(addslashes($hospital['name'] ?? '')) ?>')">
                        <i class="fas fa-trash"></i>
                      </button>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        
        <!-- Pagination -->
        <?php if (($total ?? 0) > ($perPage ?? 20)): ?>
          <nav>
            <ul class="pagination justify-content-center">
              <?php
                $totalPages = ceil(($total ?? 0) / ($perPage ?? 20));
                $currentPage = $page ?? 1;
                for ($i = 1; $i <= $totalPages; $i++):
              ?>
                <li class="page-item <?= $i === $currentPage ? 'active' : '' ?>">
                  <a class="page-link" href="?page=<?= $i ?>&q=<?= urlencode($q ?? '') ?>&status=<?= urlencode($status ?? '') ?>"><?= $i ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      <?php else: ?>
        <div class="text-center text-muted py-5">
          <i class="fas fa-hospital fa-3x mb-3"></i>
          <p>No hospitals found. <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/add">Create your first hospital</a></p>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
</div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

