<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php';
?>
<div class="main-content">
<div class="container-fluid py-4">
  <div class="page-header mb-4">
    <div class="d-flex justify-content-between align-items-start">
      <div>
        <h1 class="page-title">
          <i class="fas fa-hospital text-primary"></i>
          <span><?= htmlspecialchars($hospital['name'] ?? 'Hospital Details') ?></span>
        </h1>
        <p class="page-subtitle">Hospital details and management</p>
      </div>
      <div class="d-flex gap-2">
        <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals/edit?id=<?= (int)($hospital['id'] ?? 0) ?>" class="btn btn-primary">
          <i class="fas fa-edit"></i>
          <span>Edit</span>
        </a>
        <button type="button" class="btn btn-danger" onclick="confirmDelete(<?= (int)($hospital['id'] ?? 0) ?>, '<?= htmlspecialchars(addslashes($hospital['name'] ?? '')) ?>')">
          <i class="fas fa-trash"></i>
          <span>Delete</span>
        </button>
        <a href="<?= htmlspecialchars($base ?? '') ?>/hospitals" class="btn btn-secondary">
          <i class="fas fa-arrow-left"></i>
          <span>Back</span>
        </a>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-8">
      <div class="card shadow-md mb-4">
        <div class="card-header">
          <h5 class="mb-0">Hospital Information</h5>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-md-6">
              <label class="text-muted">Hospital Name</label>
              <div class="fw-semibold"><?= htmlspecialchars($hospital['name'] ?? '') ?></div>
            </div>
            <div class="col-md-6">
              <label class="text-muted">Hospital Code</label>
              <div><span class="badge bg-secondary"><?= htmlspecialchars($hospital['code'] ?? '') ?></span></div>
            </div>
            <div class="col-md-12">
              <label class="text-muted">Address</label>
              <div><?= htmlspecialchars($hospital['address'] ?? 'N/A') ?></div>
            </div>
            <div class="col-md-4">
              <label class="text-muted">City</label>
              <div><?= htmlspecialchars($hospital['city'] ?? 'N/A') ?></div>
            </div>
            <div class="col-md-4">
              <label class="text-muted">State</label>
              <div><?= htmlspecialchars($hospital['state'] ?? 'N/A') ?></div>
            </div>
            <div class="col-md-4">
              <label class="text-muted">Pincode</label>
              <div><?= htmlspecialchars($hospital['pincode'] ?? 'N/A') ?></div>
            </div>
            <div class="col-md-6">
              <label class="text-muted">Phone</label>
              <div><?= htmlspecialchars($hospital['phone'] ?? 'N/A') ?></div>
            </div>
            <div class="col-md-6">
              <label class="text-muted">Email</label>
              <div><?= htmlspecialchars($hospital['email'] ?? 'N/A') ?></div>
            </div>
            <div class="col-md-6">
              <label class="text-muted">Website</label>
              <div><?= !empty($hospital['website']) ? '<a href="' . htmlspecialchars($hospital['website']) . '" target="_blank">' . htmlspecialchars($hospital['website']) . '</a>' : 'N/A' ?></div>
            </div>
            <div class="col-md-6">
              <label class="text-muted">Status</label>
              <div>
                <span class="badge bg-<?= ($hospital['status'] ?? '') === 'Active' ? 'success' : (($hospital['status'] ?? '') === 'Suspended' ? 'danger' : 'secondary') ?>">
                  <?= htmlspecialchars($hospital['status'] ?? '') ?>
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card shadow-md mb-4">
        <div class="card-header">
          <h5 class="mb-0">Statistics</h5>
        </div>
        <div class="card-body">
          <div class="mb-3">
            <label class="text-muted small">Patients</label>
            <div class="h4"><?= (int)($stats['patients'] ?? 0) ?></div>
          </div>
          <div class="mb-3">
            <label class="text-muted small">Doctors</label>
            <div class="h4"><?= (int)($stats['doctors'] ?? 0) ?></div>
          </div>
          <div class="mb-3">
            <label class="text-muted small">Appointments</label>
            <div class="h4"><?= (int)($stats['appointments'] ?? 0) ?></div>
          </div>
          <div class="mb-3">
            <label class="text-muted small">Admins</label>
            <div class="h4"><?= (int)($stats['admins'] ?? 0) ?></div>
          </div>
        </div>
      </div>
      
      <div class="card shadow-md mb-4">
        <div class="card-header">
          <h5 class="mb-0">Subscription</h5>
        </div>
        <div class="card-body">
          <div class="mb-2">
            <label class="text-muted small">Plan</label>
            <div><span class="badge bg-info"><?= htmlspecialchars($hospital['subscription_plan'] ?? 'Basic') ?></span></div>
          </div>
          <div class="mb-2">
            <label class="text-muted small">Max Users</label>
            <div><?= (int)($hospital['max_users'] ?? 10) ?></div>
          </div>
          <?php if (!empty($hospital['subscription_expires_at'])): ?>
            <div class="mb-2">
              <label class="text-muted small">Expires At</label>
              <div><?= date('Y-m-d', strtotime($hospital['subscription_expires_at'])) ?></div>
            </div>
          <?php endif; ?>
        </div>
      </div>
      
      <div class="card shadow-md">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0">Quick Actions</h5>
        </div>
        <div class="card-body">
          <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/add?hospital_id=<?= (int)($hospital['id'] ?? 0) ?>" class="btn btn-primary w-100 mb-2">
            <i class="fas fa-user-plus me-2"></i>Create Hospital Admin
          </a>
          <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins?hospital_id=<?= (int)($hospital['id'] ?? 0) ?>" class="btn btn-outline-primary w-100 mb-2">
            <i class="fas fa-users me-2"></i>View All Admins
          </a>
          <a href="<?= str_replace('/superadmin', '/admin', htmlspecialchars($base ?? '')) ?>/login" target="_blank" class="btn btn-outline-success w-100">
            <i class="fas fa-external-link-alt me-2"></i>Open Hospital Panel
          </a>
        </div>
      </div>
    </div>
  </div>
  
  <!-- Hospital Admins Section -->
  <div class="row mt-4">
    <div class="col-12">
      <div class="card shadow-md">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0"><i class="fas fa-users me-2"></i>Hospital Admins</h5>
          <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/add?hospital_id=<?= (int)($hospital['id'] ?? 0) ?>" class="btn btn-sm btn-primary">
            <i class="fas fa-plus me-1"></i>Add Admin
          </a>
        </div>
        <div class="card-body">
          <?php
            // Use hospitalAdmins passed from controller
            $hospitalAdmins = $hospitalAdmins ?? [];
          ?>
          
          <?php if (!empty($hospitalAdmins)): ?>
            <div class="table-responsive">
              <table class="table table-hover">
                <thead>
                  <tr>
                    <th>User ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Created</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($hospitalAdmins as $admin): ?>
                    <tr>
                      <td><span class="badge bg-dark">#<?= (int)$admin['id'] ?></span></td>
                      <td><strong><?= htmlspecialchars($admin['name'] ?? '') ?></strong></td>
                      <td><?= htmlspecialchars($admin['email'] ?? '') ?></td>
                      <td><span class="badge bg-info"><?= htmlspecialchars($admin['role'] ?? 'admin') ?></span></td>
                      <td><?= date('Y-m-d', strtotime($admin['created_at'] ?? 'now')) ?></td>
                      <td>
                        <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/edit?id=<?= (int)$admin['id'] ?>" class="btn btn-sm btn-outline-info" title="Edit">
                          <i class="fas fa-edit"></i>
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center text-muted py-4">
              <i class="fas fa-user-slash fa-3x mb-3"></i>
              <p>No admins found for this hospital.</p>
              <a href="<?= htmlspecialchars($base ?? '') ?>/hospital-admins/add?hospital_id=<?= (int)($hospital['id'] ?? 0) ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Create First Admin
              </a>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title" id="deleteModalLabel">
          <i class="fas fa-exclamation-triangle me-2"></i>Confirm Delete
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p class="mb-3">Are you sure you want to delete this hospital?</p>
        <div class="alert alert-warning">
          <strong>Hospital:</strong> <span id="hospitalNameToDelete"></span>
        </div>
        <p class="text-danger mb-0">
          <i class="fas fa-exclamation-circle me-1"></i>
          <strong>Warning:</strong> This action cannot be undone. All associated data (patients, doctors, appointments, etc.) will be permanently deleted.
        </p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
          <i class="fas fa-times me-1"></i>Cancel
        </button>
        <form id="deleteForm" method="POST" style="display: inline;">
          <input type="hidden" name="id" id="hospitalIdToDelete">
          <button type="submit" class="btn btn-danger">
            <i class="fas fa-trash me-1"></i>Delete Hospital
          </button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
function confirmDelete(hospitalId, hospitalName) {
  document.getElementById('hospitalIdToDelete').value = hospitalId;
  document.getElementById('hospitalNameToDelete').textContent = hospitalName;
  document.getElementById('deleteForm').action = '<?= htmlspecialchars($base ?? '') ?>/hospitals/delete';
  
  const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
  deleteModal.show();
}
</script>

<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

