<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <title><?= htmlspecialchars($title ?? 'Super Admin') ?></title>
  
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts - Inter -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Super Admin Sidebar CSS -->
  <link rel="stylesheet" href="<?= htmlspecialchars($base ?? '/hms_project/superadmin') ?>/public/assets/css/sidebar.css">
  
  <!-- Super Admin Main CSS -->
  <link rel="stylesheet" href="<?= htmlspecialchars($base ?? '/hms_project/superadmin') ?>/public/assets/css/admin.css">
  
  <!-- Page-specific styles (if any) -->
  <?php if (isset($pageStyles) && !empty($pageStyles)): ?>
    <style><?= $pageStyles ?></style>
  <?php endif; ?>
</head>
<body<?= !empty($bodyClass ?? '') ? ' class="' . htmlspecialchars($bodyClass) . '"' : '' ?>>

