<?php declare(strict_types=1); 
$user = Auth::user();
?>
<!-- Top Navbar - Professional Design -->
<nav class="navbar navbar-expand-lg navbar-dark shadow-lg" style="position: fixed; top: 0; left: 280px; right: 0; z-index: 999; transition: left 0.3s cubic-bezier(0.4, 0, 0.2, 1);">
  <div class="container-fluid px-4">
    <button class="btn btn-link text-white d-lg-none p-2" type="button" id="sidebarToggle" style="text-decoration: none;">
      <i class="fas fa-bars fa-lg"></i>
    </button>
    <a class="navbar-brand fw-bold ms-2" href="<?= htmlspecialchars($base ?? '') ?>/" style="text-decoration: none;">
      <i class="fas fa-shield-alt me-2"></i>Super Admin Panel
    </a>
    <div class="ms-auto d-flex align-items-center gap-3">
      <div class="d-none d-md-flex align-items-center gap-2 px-3 py-2 bg-white bg-opacity-10 rounded-pill">
        <div class="rounded-circle bg-white bg-opacity-20 d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
          <i class="fas fa-user-shield text-white"></i>
        </div>
        <span class="text-white fw-medium"><?= htmlspecialchars($user['name'] ?? 'Admin') ?></span>
      </div>
      <a class="btn btn-outline-light btn-sm d-flex align-items-center gap-2" href="<?= htmlspecialchars($base ?? '') ?>/logout" style="text-decoration: none;">
        <i class="fas fa-sign-out-alt"></i>
        <span class="d-none d-sm-inline">Logout</span>
      </a>
    </div>
  </div>
</nav>

<style>
@media (max-width: 991.98px) {
    nav.navbar {
        left: 0 !important;
    }
}
</style>
<script>
// Mobile sidebar toggle
document.addEventListener('DOMContentLoaded', function() {
    const toggle = document.getElementById('sidebarToggle');
    const sidebar = document.getElementById('sidebar');
    if (toggle && sidebar) {
        toggle.addEventListener('click', function() {
            sidebar.classList.toggle('show');
        });
    }
});
</script>

