<?php
declare(strict_types=1);
// Determine current path for active menu highlighting
$currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?: '/';
$base = $base ?? (defined('BASE_URL') ? BASE_URL : '/hms_project/superadmin');

function is_active($path, $current) {
    if ($path === '/') return $current === '/' || $current === '/hms_project/superadmin' || $current === '/hms_project/superadmin/';
    if (strpos($current, $path) !== false) return 'active';
    return '';
}

function section_open($paths, $current) {
    foreach ($paths as $p) {
        if ($p === '/') { 
            if ($current === '/' || $current === '/hms_project/superadmin' || $current === '/hms_project/superadmin/') return 'open'; 
        }
        if (strpos($current, $p) !== false) return 'open';
    }
    return '';
}
?>
<aside class="sidebar p-0 m-0 fixed-left" id="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">
            <i class="fas fa-shield-alt"></i>
        </div>
        <div class="sidebar-title">Super Admin Panel</div>
        <div class="sidebar-subtitle">Multi-Hospital ERP</div>
    </div>
    
    <nav class="nav">
        <!-- Dashboard -->
        <div class="nav-section">
            <div class="section-title">Main</div>
            <a href="<?= htmlspecialchars($base) ?>/" class="nav-item <?= is_active('/', $currentPath) ?>">
                <span class="icon"><i class="fas fa-tachometer-alt"></i></span>
                <span class="label">Dashboard</span>
            </a>
        </div>

        <!-- Hospital Management -->
        <div class="nav-section">
            <div class="section-title">Hospital Management</div>
            <div class="nav-item js-collapser <?= section_open(['/hospitals'], $currentPath) ?>">
                <a href="#" class="icon"><i class="fas fa-hospital"></i></a>
                <span class="label">Hospitals</span>
            </div>
            <div class="nav-collapse <?= section_open(['/hospitals'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/hospitals" class="nav-item <?= is_active('/hospitals', $currentPath) ?>">
                    <span class="icon"><i class="fas fa-list"></i></span>
                    <span class="label">All Hospitals</span>
                </a>
                <a href="<?= htmlspecialchars($base) ?>/hospitals/add" class="nav-item <?= is_active('/hospitals/add', $currentPath) ?>">
                    <span class="icon"><i class="fas fa-plus-circle"></i></span>
                    <span class="label">Add New Hospital</span>
                </a>
            </div>
        </div>

        <!-- Hospital Admins Management -->
        <div class="nav-section">
            <div class="section-title">User Management</div>
            <div class="nav-item js-collapser <?= section_open(['/hospital-admins'], $currentPath) ?>">
                <a href="#" class="icon"><i class="fas fa-users-cog"></i></a>
                <span class="label">Hospital Admins</span>
            </div>
            <div class="nav-collapse <?= section_open(['/hospital-admins'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/hospital-admins" class="nav-item <?= is_active('/hospital-admins', $currentPath) ?>">
                    <span class="icon"><i class="fas fa-users"></i></span>
                    <span class="label">All Admins</span>
                </a>
                <a href="<?= htmlspecialchars($base) ?>/hospital-admins/add" class="nav-item <?= is_active('/hospital-admins/add', $currentPath) ?>">
                    <span class="icon"><i class="fas fa-user-plus"></i></span>
                    <span class="label">Add New Admin</span>
                </a>
            </div>
        </div>

        <!-- Reports & Analytics -->
        <div class="nav-section">
            <div class="section-title">Reports & Analytics</div>
            <div class="nav-item js-collapser <?= section_open(['/reports', '/analytics'], $currentPath) ?>">
                <a href="#" class="icon"><i class="fas fa-chart-line"></i></a>
                <span class="label">Reports</span>
            </div>
            <div class="nav-collapse <?= section_open(['/reports', '/analytics'], $currentPath) ?>">
                <a href="#" class="nav-item">
                    <span class="icon"><i class="fas fa-chart-bar"></i></span>
                    <span class="label">Hospital Statistics</span>
                </a>
                <a href="#" class="nav-item">
                    <span class="icon"><i class="fas fa-file-alt"></i></span>
                    <span class="label">System Reports</span>
                </a>
                <a href="#" class="nav-item">
                    <span class="icon"><i class="fas fa-download"></i></span>
                    <span class="label">Export Data</span>
                </a>
            </div>
        </div>

        <!-- System Settings -->
        <div class="nav-section">
            <div class="section-title">System</div>
            <div class="nav-item js-collapser <?= section_open(['/settings', '/system'], $currentPath) ?>">
                <a href="#" class="icon"><i class="fas fa-cog"></i></a>
                <span class="label">Settings</span>
            </div>
            <div class="nav-collapse <?= section_open(['/settings', '/system'], $currentPath) ?>">
                <a href="#" class="nav-item">
                    <span class="icon"><i class="fas fa-sliders-h"></i></span>
                    <span class="label">System Settings</span>
                </a>
                <a href="#" class="nav-item">
                    <span class="icon"><i class="fas fa-database"></i></span>
                    <span class="label">Database Backup</span>
                </a>
                <a href="#" class="nav-item">
                    <span class="icon"><i class="fas fa-key"></i></span>
                    <span class="label">Security Settings</span>
                </a>
                <a href="#" class="nav-item">
                    <span class="icon"><i class="fas fa-bell"></i></span>
                    <span class="label">Notifications</span>
                </a>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="nav-section">
            <div class="section-title">Quick Actions</div>
            <a href="<?= htmlspecialchars($base) ?>/hospitals/add" class="nav-item">
                <span class="icon"><i class="fas fa-plus-square"></i></span>
                <span class="label">Quick Add Hospital</span>
            </a>
            <a href="<?= htmlspecialchars($base) ?>/hospital-admins/add" class="nav-item">
                <span class="icon"><i class="fas fa-user-plus"></i></span>
                <span class="label">Quick Add Admin</span>
            </a>
        </div>
    </nav>

    <!-- Sidebar Footer -->
    <div class="sidebar-footer">
        <div class="sidebar-user">
            <div class="user-avatar">
                <i class="fas fa-user-shield"></i>
            </div>
            <div class="user-info">
                <div class="user-name"><?= htmlspecialchars(Auth::user()['name'] ?? 'Super Admin') ?></div>
                <div class="user-role">Super Administrator</div>
            </div>
        </div>
        <a href="<?= htmlspecialchars($base) ?>/logout" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </div>
</aside>

<script>
// Sidebar collapsible functionality
document.addEventListener('DOMContentLoaded', function() {
    const collapsers = document.querySelectorAll('.js-collapser');
    collapsers.forEach(collapser => {
        collapser.addEventListener('click', function(e) {
            e.preventDefault();
            const section = this.closest('.nav-section');
            const collapse = section.querySelector('.nav-collapse');
            
            if (section.classList.contains('open')) {
                section.classList.remove('open');
                if (collapse) collapse.classList.remove('open');
            } else {
                // Close other sections
                document.querySelectorAll('.nav-section.open').forEach(openSection => {
                    if (openSection !== section) {
                        openSection.classList.remove('open');
                        const openCollapse = openSection.querySelector('.nav-collapse');
                        if (openCollapse) openCollapse.classList.remove('open');
                    }
                });
                section.classList.add('open');
                if (collapse) collapse.classList.add('open');
            }
        });
    });
});
</script>

