<?php
declare(strict_types=1);

define('BASE_PATH', dirname(__DIR__));
define('SYSTEM_PATH', BASE_PATH . DIRECTORY_SEPARATOR . 'system');
define('APP_PATH', __DIR__ . DIRECTORY_SEPARATOR . 'app');

require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'App.php';
require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'Controller.php';
require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'Model.php';
require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'View.php';

spl_autoload_register(function ($class) {
    $paths = [
        APP_PATH . DIRECTORY_SEPARATOR . 'controllers' . DIRECTORY_SEPARATOR . $class . '.php',
        APP_PATH . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . $class . '.php',
        // Also check admin app models
        BASE_PATH . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . $class . '.php',
    ];
    foreach ($paths as $p) {
        if (is_file($p)) { require_once $p; return; }
    }
});

// Sessions for super admin auth
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// Auth helper (reuse from admin)
require_once BASE_PATH . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . 'Auth.php';

$app = new App();

// Load routes
require APP_PATH . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'routes.php';

// Base path detection
$scriptDir = rtrim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/');
$basePath = $scriptDir;

// Expose base URL for controllers and views
if (!defined('BASE_URL')) {
    define('BASE_URL', '/hms_project/superadmin');
}

// Simple route guard: allow login routes without auth
$requestUri = $_SERVER['REQUEST_URI'] ?? '/';
if (strpos($requestUri, '?') !== false) { $requestUri = strstr($requestUri, '?', true); }
$path = '/' . trim($requestUri, '/');
$base = '/' . trim($basePath, '/');
if ($base !== '/' && str_starts_with($path, $base)) {
    $relative = substr($path, strlen($base));
    $relative = '/' . ltrim($relative, '/');
} else {
    $relative = $path;
}
if ($relative === '//') { $relative = '/'; }

$publicRoutes = ['/login', '/auth/login'];
// Static assets pass-through
$isAsset = str_starts_with($relative, '/public/');
if (!$isAsset && !in_array($relative, $publicRoutes, true)) {
    $user = Auth::user();
    if (!$user || ($user['role'] ?? '') !== 'super_admin') {
        header('Location: ' . (defined('BASE_URL') ? BASE_URL : $basePath) . '/login');
        exit;
    }
}

$app->dispatch($basePath);

