<?php
declare(strict_types=1);

class Model
{
    protected static ?PDO $pdo = null;

    public function db(): PDO
    {
        if (self::$pdo instanceof PDO) {
            return self::$pdo;
        }

        if (!defined('APP_PATH')) {
            throw new RuntimeException('APP_PATH is not defined.');
        }

        $configFile = rtrim(APP_PATH, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'database.php';
        if (!is_file($configFile)) {
            throw new RuntimeException('Database config not found: ' . $configFile);
        }
        $config = require $configFile; // expects ['dsn' => '', 'user' => '', 'pass' => '', 'options' => []]

        $options = $config['options'] ?? [];
        $defaults = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ];
        $options = $options + $defaults;

        self::$pdo = new PDO($config['dsn'], $config['user'] ?? '', $config['pass'] ?? '', $options);
        return self::$pdo;
    }
}

