<?php
/**
 * Test Complete Login Flow
 * This simulates the exact login process
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');

echo "<h2>Test Login Flow</h2><pre>";

// Step 1: Load required files
echo "Step 1: Loading files...\n";
define('BASE_PATH', dirname(__DIR__));
define('SYSTEM_PATH', BASE_PATH . DIRECTORY_SEPARATOR . 'system');
define('APP_PATH', BASE_PATH . DIRECTORY_SEPARATOR . 'superadmin' . DIRECTORY_SEPARATOR . 'app');

require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASE_PATH . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Admin.php';
require_once BASE_PATH . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . 'Auth.php';

echo "✓ Files loaded\n\n";

// Step 2: Start session
echo "Step 2: Starting session...\n";
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
echo "✓ Session started\n\n";

// Step 3: Test Admin Model
echo "Step 3: Testing Admin Model...\n";
$email = 'superadmin@hms.local';
$password = 'password';

try {
    $adminModel = new Admin();
    $user = $adminModel->findByEmail($email);
    
    if (!$user) {
        echo "✗ User not found!\n";
        exit;
    }
    
    echo "✓ User found:\n";
    echo "   ID: {$user['id']}\n";
    echo "   Name: {$user['name']}\n";
    echo "   Email: {$user['email']}\n";
    echo "   Role: " . ($user['role'] ?? 'MISSING') . "\n";
    echo "   Password Hash: " . substr($user['password_hash'] ?? '', 0, 20) . "...\n\n";
    
    // Step 4: Verify password
    echo "Step 4: Verifying password...\n";
    if (!password_verify($password, (string)($user['password_hash'] ?? ''))) {
        echo "✗ Password verification FAILED!\n";
        exit;
    }
    echo "✓ Password verified\n\n";
    
    // Step 5: Check role
    echo "Step 5: Checking role...\n";
    $userRole = $user['role'] ?? '';
    echo "   User role: '{$userRole}'\n";
    echo "   Required: 'super_admin'\n";
    
    if ($userRole !== 'super_admin') {
        echo "✗ Role mismatch! User role is '{$userRole}' but should be 'super_admin'\n";
        exit;
    }
    echo "✓ Role is correct\n\n";
    
    // Step 6: Test Auth::login()
    echo "Step 6: Testing Auth::login()...\n";
    Auth::login($user);
    
    $sessionUser = Auth::user();
    if (!$sessionUser) {
        echo "✗ Session user not set!\n";
        exit;
    }
    
    echo "✓ Auth::login() successful\n";
    echo "   Session user:\n";
    echo "   ID: {$sessionUser['id']}\n";
    echo "   Name: {$sessionUser['name']}\n";
    echo "   Email: {$sessionUser['email']}\n";
    echo "   Role: {$sessionUser['role']}\n\n";
    
    // Step 7: Verify session role
    echo "Step 7: Verifying session role...\n";
    if (($sessionUser['role'] ?? '') !== 'super_admin') {
        echo "✗ Session role is '{$sessionUser['role']}' but should be 'super_admin'\n";
        echo "   This is the issue! Auth::login() is not preserving the role correctly.\n";
        exit;
    }
    echo "✓ Session role is correct\n\n";
    
    echo "========================================\n";
    echo "✓ All tests passed! Login should work.\n";
    echo "========================================\n";
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "</pre>";
?>

