<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Hospital') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/site.css" rel="stylesheet">
</head>
<body>
  <nav class="navbar navbar-expand-lg bg-body-tertiary">
    <div class="container">
      <a class="navbar-brand fw-bold" href="<?= htmlspecialchars($base) ?>/">Hospital</a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="nav">
        <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
          <li class="nav-item"><a class="nav-link active" href="<?= htmlspecialchars($base) ?>/">Home</a></li>
          <li class="nav-item"><a class="nav-link" href="#services">Services</a></li>
          <li class="nav-item"><a class="nav-link" href="#doctors">Doctors</a></li>
          <li class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
        </ul>
      </div>
    </div>
  </nav>

  <header class="py-5 bg-primary text-white">
    <div class="container text-center">
      <h1 class="display-5 fw-semibold">Compassionate Care, Advanced Medicine</h1>
      <p class="lead">OPD, IPD, Pharmacy, Laboratory and more – all in one place.</p>
      <a href="#services" class="btn btn-light btn-lg">Explore Services</a>
      <a href="#doctors" class="btn btn-light btn-lg">Explore Doctors</a>
      <a href="#doctors" class="btn btn-light btn-lg">About Me</a>
      
    </div>
  </header>

  <section id="services" class="py-5">
    <div class="container">
      <div class="row g-4">
        <div class="col-12 col-md-4">
          <div class="card h-100">
            <div class="card-body">
              <h5 class="card-title">Outpatient (OPD)</h5>
              <p class="card-text">Quick consultations and follow-ups with expert physicians.</p>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-4">
          <div class="card h-100">
            <div class="card-body">
              <h5 class="card-title">Inpatient (IPD)</h5>
              <p class="card-text">Comfortable wards, continuous monitoring, and compassionate nursing.</p>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-4">
          <div class="card h-100">
            <div class="card-body">
              <h5 class="card-title">Laboratory</h5>
              <p class="card-text">Accurate diagnostics with modern equipment.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <footer class="py-4 bg-light">
    <div class="container text-center">
      <small>&copy; <?= date('Y') ?> Hospital. All rights reserved.</small>
    </div>
  </footer>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="/website/public/assets/js/site.js"></script>
</body>
<!-- Minimal inline styles for quick visual polish; move to site.css later -->
<style>
  header { background: linear-gradient(135deg, #0d6efd, #5aa9ff); }
  .card { border: 0; box-shadow: 0 0.25rem 0.75rem rgba(0,0,0,.075); }
  .navbar .navbar-brand { letter-spacing: .5px; }
  .navbar .nav-link { font-weight: 500; }
  .navbar .nav-link.active { color: #0d6efd; }
</style>
</html>

