<?php
declare(strict_types=1);

define('BASE_PATH', dirname(__DIR__));
define('SYSTEM_PATH', BASE_PATH . DIRECTORY_SEPARATOR . 'system');
define('APP_PATH', __DIR__ . DIRECTORY_SEPARATOR . 'app');

require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'App.php';
require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'Controller.php';
require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'Model.php';
require_once SYSTEM_PATH . DIRECTORY_SEPARATOR . 'View.php';

spl_autoload_register(function ($class) {
    $paths = [
        APP_PATH . DIRECTORY_SEPARATOR . 'controllers' . DIRECTORY_SEPARATOR . $class . '.php',
        APP_PATH . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . $class . '.php',
    ];
    foreach ($paths as $p) {
        if (is_file($p)) { require_once $p; return; }
    }
});

$app = new App();

// Load routes (should call $app->get/post)
require APP_PATH . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'routes.php';

// Auto-detect base path from script location for routing
$scriptDir = rtrim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/');
$basePath = $scriptDir;

// Expose base URL for controllers and views
if (!defined('BASE_URL')) {
    define('BASE_URL', $basePath);
}

$app->dispatch($basePath);

