<?php
require_once __DIR__ . "/biometric_config.php";

/* ----------------------------------------------------------
   This file ONLY fetches raw logs from all devices.
----------------------------------------------------------- */

function fetchAllBiometricLogs($conn, $hospital_id)
{
    $devices = getAllActiveDevices($conn, $hospital_id);

    if (empty($devices)) {
        return ["error" => "No biometric devices found."];
    }

    $merged_logs = [];

    foreach ($devices as $device) {

        $raw = fetchDeviceLogs($device);

        if (!$raw) {
            $merged_logs[] = [
                "device_id"   => $device['id'],
                "device_name" => $device['device_name'],
                "error"       => "Device offline"
            ];
            continue;
        }

        $decoded = json_decode($raw, true);

        if (!is_array($decoded)) {
            $merged_logs[] = [
                "device_id"   => $device['id'],
                "device_name" => $device['device_name'],
                "error"       => "Invalid data format"
            ];
            continue;
        }

        foreach ($decoded as $log) {
            if (
                empty($log['employee_id']) ||
                empty($log['date']) ||
                empty($log['time'])
            ) continue;

            $log['device_id']       = $device['id'];
            $log['device_name']     = $device['device_name'];
            $log['device_location'] = $device['device_location'];

            $merged_logs[] = $log;
        }
    }

    return $merged_logs;
}
?>
