<?php
require_once __DIR__ . "/biometric_fetch.php";

/* ----------------------------------------------------------
   This file ONLY converts raw logs → usable attendance array.
----------------------------------------------------------- */

function processBiometricLogs($conn, $hospital_id)
{
    $logs = fetchAllBiometricLogs($conn, $hospital_id);

    if (isset($logs['error'])) {
        return $logs;
    }

    $final = [];

    foreach ($logs as $log) {

        if (isset($log['error'])) continue;

        $staff_code = $conn->real_escape_string($log['employee_id']);
        $date       = $conn->real_escape_string($log['date']);
        $time       = $conn->real_escape_string($log['time']);

        // Match staff (doctor + staff_management)
        $sql = "
            SELECT id, full_name, 'doctor' AS role, 'doctors' AS tbl
            FROM doctors
            WHERE staff_id='$staff_code' AND hospital_id='$hospital_id'

            UNION

            SELECT id, full_name, staff_type AS role, 'staff_management' AS tbl
            FROM staff_management
            WHERE staff_id='$staff_code' AND hospital_id='$hospital_id'
        ";

        $res = $conn->query($sql);

        if ($res && $res->num_rows > 0) {

            $staff = $res->fetch_assoc();

            $final[] = [
                "auto_id"       => $staff['id'],
                "name"          => $staff['full_name'],
                "role"          => $staff['role'],
                "table"         => $staff['tbl'],
                "staff_code"    => $staff_code,
                "date"          => $date,
                "time"          => $time,
                "device_id"     => $log['device_id'],
                "device_name"   => $log['device_name'],
                "location"      => $log['device_location'],
                "status"        => "present"
            ];
        }
    }

    return $final;
}
?>
