// main.js

document.addEventListener('DOMContentLoaded', function() {

    // ====== STAFF BAR CHART ======
    const staffChartEl = document.getElementById('staffChart');
    if (staffChartEl) {
        const staffCtx = staffChartEl.getContext('2d');
        new Chart(staffCtx, {
            type: 'bar',
            data: {
                labels: ['Doctors', 'Nurses', 'Pharmacists', 'Laboratorists', 'Accountants'],
                datasets: [{
                    label: 'Count',
                    data: [
                        Number(staffChartEl.dataset.doctors),
                        Number(staffChartEl.dataset.nurses),
                        Number(staffChartEl.dataset.pharmacists),
                        Number(staffChartEl.dataset.labs),
                        Number(staffChartEl.dataset.accountants)
                    ],
                    backgroundColor: ['#00c0ef', '#dd4b39', '#00a65a', '#f39c12', '#3c8dbc']
                }]
            },
            options: {
                responsive: true,
                plugins: { legend: { display: false } },
                scales: { y: { beginAtZero: true } }
            }
        });
    }

    // ====== RESOURCE PIE CHART ======
    const resourceChartEl = document.getElementById('resourceChart');
    if (resourceChartEl) {
        const resourceCtx = resourceChartEl.getContext('2d');
        new Chart(resourceCtx, {
            type: 'pie',
            data: {
                labels: ['Patients', 'Medicines', 'Beds'],
                datasets: [{
                    data: [
                        Number(resourceChartEl.dataset.patients),
                        Number(resourceChartEl.dataset.medicines),
                        Number(resourceChartEl.dataset.beds)
                    ],
                    backgroundColor: ['#f56954', '#00a65a', '#3c8dbc']
                }]
            },
            options: {
                responsive: true,
                plugins: { legend: { position: 'bottom' } }
            }
        });
    }

    // ====== PROFILE PHOTO LIVE PREVIEW ======
    const profileInput = document.getElementById('profile_photo_input');
    const profilePreview = document.getElementById('profile_photo_preview');
    if (profileInput && profilePreview) {
        profileInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if(file){
                const reader = new FileReader();
                reader.onload = function(ev){
                    profilePreview.src = ev.target.result;
                    profilePreview.style.display = 'block';
                }
                reader.readAsDataURL(file);
            } else {
                profilePreview.style.display = 'none';
            }
        });
    }

    // ====== DOCUMENTS LIVE PREVIEW ======
    const docInput = document.getElementById('documents_input');
    const docPreview = document.getElementById('documents_preview');
    if(docInput && docPreview){
        docInput.addEventListener('change', function(e){
            docPreview.innerHTML = '';
            for(let i=0; i<e.target.files.length; i++){
                const file = e.target.files[i];
                let fileDiv = document.createElement('div');
                fileDiv.style.marginBottom = '5px';

                if(file.type.startsWith('image/')){
                    const img = document.createElement('img');
                    img.src = URL.createObjectURL(file);
                    img.style.maxWidth = '100px';
                    img.style.marginRight = '10px';
                    fileDiv.appendChild(img);
                } else if(file.type === 'application/pdf'){
                    const pdfIcon = document.createElement('span');
                    pdfIcon.innerText = '📄 ' + file.name;
                    fileDiv.appendChild(pdfIcon);
                } else {
                    const otherIcon = document.createElement('span');
                    otherIcon.innerText = '📁 ' + file.name;
                    fileDiv.appendChild(otherIcon);
                }

                docPreview.appendChild(fileDiv);
            }
        });
    }

});
