<?php
session_start();
include dirname(__DIR__, 2) . "/config/config.php";
include dirname(__DIR__, 2) . "/config/biometric_process.php";

include __DIR__ . "/../includes/hospital_head.php";
include __DIR__ . "/../includes/hospital_header.php";
include __DIR__ . "/../includes/hospital_sidebar.php";

if (!isset($_SESSION['hospital_id'])) {
    header("Location: ../includes/log/login.php");
    exit;
}

$hospital_id = (int)$_SESSION['hospital_id'];

$selected_month = $_GET['month'] ?? date("Y-m");
$selected_role  = $_GET['role']  ?? "";
$selected_staff = $_GET['staff'] ?? "";
$selected_status = $_GET['status'] ?? "";
$selected_device = $_GET['device'] ?? "";

$month_start = $selected_month . "-01";
$month_end   = date("Y-m-t", strtotime($month_start));

$error = "";
$success = "";

/* =====================
   STAFF LIST Fetch 
=====================*/

$staff_map = [];

// Doctors
if ($selected_role === "doctor" || $selected_role === "") {
    $dq = $conn->query("SELECT id, full_name, staff_id FROM doctors WHERE hospital_id='$hospital_id' ORDER BY full_name");
    while ($r = $dq->fetch_assoc()) {
        $aid = (int)$r['id'];
        $staff_map[$aid] = [
            "auto_id" => $aid,
            "name"    => $r['full_name'],
            "role"    => "doctor",
            "table"   => "doctors",
            "staff_id"=> $r['staff_id']
        ];
    }
}

// Staff table (filter role or all)
$sq = $conn->query("
    SELECT id, full_name, staff_id, staff_type 
    FROM staff_management 
    WHERE hospital_id='$hospital_id'
    " . ($selected_role !== "" && $selected_role !== "doctor" ? 
        " AND staff_type='".$conn->real_escape_string($selected_role)."'" : "") . "
    ORDER BY full_name
");

while ($r = $sq->fetch_assoc()) {
    $aid = (int)$r['id'];
    if ($selected_role !== "doctor") {
        $staff_map[$aid] = [
            "auto_id" => $aid,
            "name"    => $r['full_name'],
            "role"    => $r['staff_type'],
            "table"   => "staff_management",
            "staff_id"=> $r['staff_id']
        ];
    }
}

/* =============================
   FETCH Attendance For Month
=============================*/

$attendance_rows = [];
$att_q = $conn->query("
    SELECT * 
    FROM attendance 
    WHERE hospital_id='$hospital_id'
    AND attendance_date BETWEEN '$month_start' AND '$month_end'
");

while ($r = $att_q->fetch_assoc()) {
    $aid = (int)$r['staff_auto_id'];
    if (!isset($attendance_rows[$aid])) $attendance_rows[$aid] = [];
    $attendance_rows[$aid][$r['attendance_date']] = $r;
}

/* ==================================
   CALCULATE SUMMARY for Each Staff
==================================*/

$staff_summaries = [];
$overall = ["present"=>0,"absent"=>0,"leave"=>0,"late"=>0];

foreach ($staff_map as $aid => $meta) {

    $rows = $attendance_rows[$aid] ?? [];

    $p = $a = $l = $late = 0;

    foreach ($rows as $date => $r) {
        $st = strtolower($r['status']);
        if ($st === "present") $p++;
        elseif ($st === "absent") $a++;
        elseif ($st === "leave") $l++;

        if (!empty($r["punch_in"]) && strtotime($r["punch_in"]) > strtotime("09:10:00"))
            $late++;
    }

    $staff_summaries[$aid] = [
        "meta" => $meta,
        "present" => $p,
        "absent"  => $a,
        "leave"   => $l,
        "late"    => $late,
        "daily"   => $rows
    ];

    $overall["present"] += $p;
    $overall["absent"]  += $a;
    $overall["leave"]   += $l;
    $overall["late"]    += $late;
}
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
.content-wrapper { margin-left:250px; padding:25px; }
.summary-box { background:#f4f7fe; padding:20px; border-radius:10px; text-align:center; }
.table thead th { background:#0d6efd; color:white; }
</style>

<div class="content-wrapper">
    
    

<div class="container-fluid">
    <br>
    <div class="mb-3 d-flex gap-2">
    <!-- TAKE ATTENDANCE (Exact Same Design) -->
    <a href="<?php echo MENU_PATH; ?>attendance/view_attendance.php" class="btn btn-warning">
        <i class="fa-solid fa-user-check me-1"></i> View Attendance
    </a>

</div>

<h3 class="fw-bold mb-4"><i class="fa-solid fa-chart-line me-2"></i> Monthly Attendance Report</h3>


<!-- Filters -->
<form method="GET" class="row g-3 mb-4">
    
    <div class="col-md-3">
        <label class="form-label fw-semibold">Select Month</label>
        <input type="month" name="month" value="<?= $selected_month ?>" class="form-control">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-semibold">Role</label>
        <select name="role" class="form-select">
            <option value="">All</option>
            <option value="doctor" <?= $selected_role=="doctor"?"selected":"" ?>>Doctor</option>
            <?php
                $roles = $conn->query("SELECT DISTINCT staff_type FROM staff_management WHERE hospital_id='$hospital_id'");
                while ($r = $roles->fetch_assoc()):
            ?>
            <option value="<?= $r['staff_type'] ?>" <?= $selected_role==$r['staff_type']?"selected":"" ?>>
                <?= ucfirst($r['staff_type']) ?>
            </option>
            <?php endwhile; ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label fw-semibold">Staff Name</label>
        <input type="text" name="staff" value="<?= $selected_staff ?>" placeholder="Search..." class="form-control">
    </div>

    <div class="col-md-3 d-flex align-items-end">
        <button class="btn btn-primary w-100"><i class="fa-solid fa-search me-1"></i> Search</button>
    </div>

</form>

<!-- Summary Boxes -->
<div class="row g-3 mb-4">
    <div class="col-md-3"><div class="summary-box">Present: <b><?= $overall['present'] ?></b></div></div>
    <div class="col-md-3"><div class="summary-box">Absent: <b><?= $overall['absent'] ?></b></div></div>
    <div class="col-md-3"><div class="summary-box">Leave: <b><?= $overall['leave'] ?></b></div></div>
    <div class="col-md-3"><div class="summary-box">Late: <b><?= $overall['late'] ?></b></div></div>
</div>
<!-- MAIN REPORT TABLE -->
<div class="table-responsive">
<table class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>Sr.No</th>
            <th>Name</th>
            <th>Role</th>
            <th>Present</th>
            <th>Absent</th>
            <th>Leave</th>
            <th>Late</th>
            <th>Details</th>
        </tr>
    </thead>
    <tbody>

<?php 
$i=1;
foreach ($staff_summaries as $aid => $s):

    if ($selected_staff && stripos($s['meta']['name'], $selected_staff) === false) continue;
?>
<tr>
    <td><?= $i++ ?></td>
    <td><?= $s['meta']['name'] ?></td>
    <td><?= ucfirst($s['meta']['role']) ?></td>
    <td><?= $s['present'] ?></td>
    <td><?= $s['absent'] ?></td>
    <td><?= $s['leave'] ?></td>
    <td><?= $s['late'] ?></td>
    <td><button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#detail<?= $aid ?>">View</button></td>
</tr>
<?php endforeach; ?>

    </tbody>
</table>
</div>
<!-- EXPORT BUTTONS -->
<div class="mt-4 mb-5 text-end">
    <button class="btn btn-success me-2" onclick="exportCSV()"><i class="fa-solid fa-file-csv me-1"></i> Export CSV</button>
    <button class="btn btn-info me-2" onclick="exportExcel()"><i class="fa-solid fa-file-excel me-1"></i> Export Excel</button>
    <button class="btn btn-danger me-2" onclick="exportPDF()"><i class="fa-solid fa-file-pdf me-1"></i> Export PDF</button>
    <button class="btn btn-secondary" onclick="window.print()"><i class="fa-solid fa-print me-1"></i> Print</button>
</div>

<?php foreach ($staff_summaries as $aid => $sum): ?>
<div class="modal fade" id="detail<?= $aid ?>" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><?= $sum['meta']['name'] ?> — <?= date("F Y", strtotime($month_start)) ?></h5>
        <button class="btn btn-primary btn-sm me-2" onclick="printModal('modalBody<?= $aid ?>')">Print</button>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body" id="modalBody<?= $aid ?>">
        <h6 class="mb-3"><b>Monthly Summary</b></h6>

        <div class="row mb-4">
            <div class="col-md-3">Present: <b><?= $sum['present'] ?></b></div>
            <div class="col-md-3">Absent: <b><?= $sum['absent'] ?></b></div>
            <div class="col-md-3">Leave: <b><?= $sum['leave'] ?></b></div>
            <div class="col-md-3">Late: <b><?= $sum['late'] ?></b></div>
        </div>

        <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Punch In</th>
                    <th>Punch Out</th>
                    <th>Device</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $period = new DatePeriod(new DateTime($month_start), new DateInterval('P1D'), (new DateTime($month_end))->modify('+1 day'));
            foreach ($period as $dt):
                $d = $dt->format("Y-m-d");
                $r = $sum['daily'][$d] ?? null;
            ?>
            <tr>
                <td><?= $d ?></td>
                <td><?= $r["status"] ?? "-" ?></td>
                <td><?= $r["punch_in"] ?? "-" ?></td>
                <td><?= $r["punch_out"] ?? "-" ?></td>
                <td><?= $r["device_name"] ?? "-" ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        </div>
      </div>

    </div>
  </div>
</div>
<?php endforeach; ?>

<?php
include_once __DIR__ . "/../includes/hospital_scripts.php";
include_once __DIR__ . "/../includes/hospital_footer.php";
?>

<script>
function printModal(id){
    var content = document.getElementById(id).innerHTML;
    var win = window.open("", "PRINT", "height=700,width=900");
    win.document.write("<html><head><title>Print</title>");
    win.document.write("</head><body>");
    win.document.write(content);
    win.document.write("</body></html>");
    win.document.close();
    win.focus();
    win.print();
}

function exportCSV(){
    window.location.href = "export_csv.php?month=<?= $selected_month ?>&role=<?= $selected_role ?>";
}

function exportExcel(){
    window.location.href = "export_excel.php?month=<?= $selected_month ?>&role=<?= $selected_role ?>";
}

function exportPDF(){
    window.location.href = "export_pdf.php?month=<?= $selected_month ?>&role=<?= $selected_role ?>";
}
</script>

</div>
</div>
