<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'] . "/multi_hospital2/config/config.php";

if (!isset($_SESSION['hospital_id'])) {
    header("Location: ../../login/hospital_login.php");
    exit;
}

$hospital_id   = (int) $_SESSION['hospital_id'];
$staff_list    = [];
$selected_type = "";
$selected_date = date('Y-m-d');
$msg           = "";
$error         = "";

/* ============== SAVE ATTENDANCE (ON SUBMIT) ============== */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_attendance'])) {

    $selected_date = $_POST['selected_date'] ?? $selected_date;
    $selected_type = $_POST['selected_type'] ?? "";

    $statuses     = $_POST['status']      ?? [];
    $time_in_arr  = $_POST['time_in']     ?? [];
    $time_out_arr = $_POST['time_out']    ?? [];
    $name_arr     = $_POST['name_arr']    ?? [];
    $role_arr     = $_POST['role_arr']    ?? [];
    $type_arr     = $_POST['type_arr']    ?? [];
    $table_arr    = $_POST['table_arr']   ?? [];
    $code_arr     = $_POST['code_arr']    ?? [];
    $late_arr     = $_POST['late_note']   ?? [];

    $saved     = 0;
    $date_safe = $conn->real_escape_string($selected_date);

    if (empty($statuses)) {
        $error = "No attendance selected.";
    } else {
        foreach ($statuses as $id => $status_label) {

            $id_int = (int)$id;
            $status_label = trim($status_label);
            if ($status_label === "") continue;

            $full_name   = $conn->real_escape_string($name_arr[$id]   ?? "");
            $staff_role  = $conn->real_escape_string($role_arr[$id]   ?? "");
            $staff_type  = $conn->real_escape_string($type_arr[$id]   ?? "");
            $staff_table = $conn->real_escape_string($table_arr[$id]  ?? "");
            $staff_code  = $conn->real_escape_string($code_arr[$id]   ?? "");
            $punch_in    = $conn->real_escape_string($time_in_arr[$id]  ?? "");
            $punch_out   = $conn->real_escape_string($time_out_arr[$id] ?? "");
            $note        = $conn->real_escape_string($late_arr[$id]     ?? "");

            if ($staff_table === "" || $staff_role === "") continue;

            // duplicate check
            $chk_sql = "
                SELECT id FROM attendance
                WHERE hospital_id='{$hospital_id}'
                  AND staff_auto_id='{$id_int}'
                  AND staff_table='{$staff_table}'
                  AND attendance_date='{$date_safe}'
                LIMIT 1
            ";
            $chk = $conn->query($chk_sql);
            if ($chk && $chk->num_rows > 0) continue;

            $status_safe    = $conn->real_escape_string($status_label);
            $punch_in_sql   = ($punch_in  !== "") ? "'{$punch_in}'"  : "NULL";
            $punch_out_sql  = ($punch_out !== "") ? "'{$punch_out}'" : "NULL";
            $note_sql       = ($note      !== "") ? "'{$note}'"      : "NULL";
            
            


            $ins = "
                INSERT INTO attendance
                (hospital_id, full_name, staff_role, staff_type, staff_table,
                staff_auto_id, staff_id, attendance_date, status,
                punch_in, punch_out, note, created_at)
                VALUES
                ('{$hospital_id}', '{$full_name}', '{$staff_role}', '{$staff_type}', '{$staff_table}',
                '{$id_int}', '{$staff_code}', '{$date_safe}', '{$status_safe}',
                {$punch_in_sql}, {$punch_out_sql}, {$note_sql}, NOW())
";

            if ($conn->query($ins)) {
                $saved++;
            }
        }

        if ($saved > 0) {
            $msg = "Attendance saved for {$saved} staff.";
        } else {
            if ($error === "") $error = "No new attendance saved (maybe already exists).";
        }
    }
}

/* ============== FILTER (LOAD STAFF BUTTON) ============== */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['load_staff'])) {
    $selected_type = $_POST['role'] ?? "";
    $selected_date = $_POST['date'] ?? $selected_date;
}

/* ============== LOAD STAFF LIST (AUTO + FILTER) ============== */
/*  Grace Time = 30 minutes is used in JS for Late detection     */

if ($selected_type === "doctor") {
    $sql = "
        SELECT 
            d.id,
            d.full_name,
            d.staff_id,
            d.specialization AS info,
            'doctor'  AS staff_role,
            'doctor'  AS staff_type,
            'doctor'  AS staff_table,
            d.duty_from,
            d.duty_to
        FROM doctors d
        WHERE d.hospital_id = '{$hospital_id}'
        ORDER BY d.full_name
    ";
} elseif ($selected_type !== "") {
    $safe_type = $conn->real_escape_string($selected_type);
    $sql = "
        SELECT 
            s.id,
            s.full_name,
            s.staff_id,
            s.staff_type AS info,
            'staff'       AS staff_role,
            s.staff_type  AS staff_type,
            'staff'       AS staff_table,
            s.duty_from,
            s.duty_to
        FROM staff_management s
        WHERE s.hospital_id = '{$hospital_id}'
          AND s.staff_type = '{$safe_type}'
        ORDER BY s.full_name
    ";
} else {
    // Default: all doctors + all staff
    $sql = "
        SELECT 
            d.id,
            d.full_name,
            d.staff_id,
            d.specialization AS info,
            'doctor' AS staff_role,
            'doctor' AS staff_type,
            'doctor' AS staff_table,
            d.duty_from,
            d.duty_to
        FROM doctors d
        WHERE d.hospital_id = '{$hospital_id}'

        UNION ALL

        SELECT 
            s.id,
            s.full_name,
            s.staff_id,
            s.staff_type AS info,
            'staff'      AS staff_role,
            s.staff_type AS staff_type,
            'staff'      AS staff_table,
            s.duty_from,
            s.duty_to
        FROM staff_management s
        WHERE s.hospital_id = '{$hospital_id}'

        ORDER BY full_name
    ";
}

$staff_list = [];
$res = $conn->query($sql);
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $staff_list[] = $row;
    }
} else {
    $error = "Database error while loading staff: " . $conn->error;
}

/* ============== UI INCLUDES ============== */
include __DIR__ . "/../includes/hospital_head.php";
include __DIR__ . "/../includes/hospital_header.php";
include __DIR__ . "/../includes/hospital_sidebar.php";
?>

<style>
.content-wrapper{
    margin-left:260px !important;
    padding:35px;
    background:#eef3fa;
    min-height:100vh;
}
.card-header-box{
    background:#fff;
    padding:16px 20px;
    border-radius:10px;
    box-shadow:0 3px 12px rgba(0,0,0,.08);
    margin-bottom:18px;
    border-left:5px solid #0d6efd;
}
.card-box{
    background:#fff;
    padding:14px 18px;
    border-radius:12px;
    box-shadow:0 3px 10px rgba(0,0,0,.06);
    margin-bottom:10px;
}
.user-img{
    width:48px;
    height:48px;
    border-radius:50%;
    object-fit:cover;
    border:2px solid #e0e0e0;
}
.status-btn{
    padding:5px 12px;
    border-radius:20px;
    border:none;
    font-size:13px;
    cursor:pointer;
    transition:.2s;
    color:#fff;
}
.status-btn.present{background:#198754;}
.status-btn.absent{background:#dc3545;}
.status-btn.leave{background:#ffc107;color:#000;}
.status-btn.halfday{background:#0dcaf0;color:#000;}
.status-btn.active{
    box-shadow:0 0 8px rgba(0,0,0,.25);
    transform:scale(1.05);
}
.status-btn:not(.active){opacity:.55;}

.time-wrapper{
    margin-top:8px;
    border-top:1px dashed #e0e0e0;
    padding-top:8px;
    display:none;
    font-size:13px;
}
.time-wrapper label{
    font-weight:500;
    margin-right:4px;
}
.time-wrapper input[type="time"]{
    width:130px;
    display:inline-block;
}
.late-badge{
    background:#ffcc00;
    color:#000;
    font-size:11px;
    padding:2px 6px;
    border-radius:4px;
    margin-left:8px;
    display:none;
}
</style>

<div class="content-wrapper">

    <div class="card-header-box">
        <h4 class="fw-bold mb-1">
            <i class="fa-solid fa-calendar-check me-2 text-primary"></i>Take Attendance
        </h4>
        <small class="text-muted">Present / Absent / Leave / Half Day with duty-time based auto timing</small>
    </div>

    <div class="container-fluid">

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <?php if ($msg): ?>
            <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
        <?php endif; ?>

        <!-- FILTER / LOAD FORM -->
        <div class="card p-3 mb-4">
            <form method="POST" class="row g-3 align-items-end">

                <div class="col-md-4">
                    <label class="form-label fw-semibold">Staff Type</label>
                    <select name="role" class="form-select">
                        <option value="">All Staff (Default)</option>
                        <option value="doctor" <?= $selected_type === 'doctor' ? 'selected' : '' ?>>Doctor</option>
                        <?php
                        $tres = $conn->query("SELECT DISTINCT staff_type FROM staff_management WHERE hospital_id='{$hospital_id}' AND staff_type<>''");
                        if ($tres) {
                            while ($t = $tres->fetch_assoc()) {
                                $val = $t['staff_type'];
                                echo '<option value="'.htmlspecialchars($val).'"'.($selected_type==$val?' selected':'').'>'.htmlspecialchars(ucfirst($val)).'</option>';
                            }
                        }
                        ?>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="form-label fw-semibold">Date</label>
                    <input type="date" name="date" class="form-control" value="<?= htmlspecialchars($selected_date) ?>" required>
                </div>

                <div class="col-md-3">
                    <button name="load_staff" class="btn btn-primary w-100">
                        <i class="fa-solid fa-users me-1"></i> Load Staff
                    </button>
                </div>

            </form>
        </div>

        <!-- STAFF LIST -->
        <?php if (!empty($staff_list)): ?>
        <form method="POST">

            <input type="hidden" name="selected_date" value="<?= htmlspecialchars($selected_date) ?>">
            <input type="hidden" name="selected_type" value="<?= htmlspecialchars($selected_type) ?>">

            <div class="d-flex flex-wrap gap-2 mb-3">
                <button type="button" class="btn btn-success btn-sm" onclick="markAll('Present')">Mark All Present</button>
                <button type="button" class="btn btn-danger btn-sm" onclick="markAll('Absent')">Mark All Absent</button>
            </div>

            <?php foreach ($staff_list as $s):
                $id = (int)$s['id'];
                $duty_from = trim($s['duty_from'] ?? '');
                $duty_to   = trim($s['duty_to']   ?? '');
            ?>
            <div class="card-box row-attendance" id="row<?= $id ?>"
                 data-id="<?= $id ?>"
                 data-duty-from="<?= htmlspecialchars($duty_from) ?>"
                 data-duty-to="<?= htmlspecialchars($duty_to) ?>">

                <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                    <!-- LEFT -->
                    <div class="d-flex align-items-center">
                        <img src="/multi_hospital2/uploads/staff/<?= htmlspecialchars($s['staff_id']) ?>.jpg"
                             onerror="this.src='https://via.placeholder.com/50'"
                             class="user-img">
                        <div class="ms-3">
                            <div class="fw-bold"><?= htmlspecialchars($s['full_name']) ?></div>
                            <small class="text-muted">
                                <?= htmlspecialchars($s['info']) ?> (<?= htmlspecialchars($s['staff_role']) ?>)
                            </small>
                            <div>
                                <small class="text-muted">
                                    Duty: <?= htmlspecialchars($duty_from ?: '--') ?> - <?= htmlspecialchars($duty_to ?: '--') ?>
                                </small>
                                <span class="late-badge" id="lateBadge<?= $id ?>">Late</span>
                            </div>
                        </div>
                    </div>

                    <!-- RIGHT: STATUS BUTTONS -->
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="status-btn present btn-status"
                                data-status="Present"
                                onclick="setStatus(<?= $id ?>,'Present',this)">
                            Present
                        </button>
                        <button type="button" class="status-btn absent btn-status"
                                data-status="Absent"
                                onclick="setStatus(<?= $id ?>,'Absent',this)">
                            Absent
                        </button>
                        <button type="button" class="status-btn leave btn-status"
                                data-status="Leave"
                                onclick="setStatus(<?= $id ?>,'Leave',this)">
                            Leave
                        </button>
                        <button type="button" class="status-btn halfday btn-status"
                                data-status="Half Day"
                                onclick="setStatus(<?= $id ?>,'Half Day',this)">
                            Half Day
                        </button>

                        <input type="hidden" name="status[<?= $id ?>]" id="status<?= $id ?>" value="">
                    </div>
                </div>

                <!-- TIME INPUTS -->
                <div class="time-wrapper" id="timeBox<?= $id ?>">
                    <label>Time In</label>
                    <input type="time" name="time_in[<?= $id ?>]">
                    <label class="ms-3">Time Out</label>
                    <input type="time" name="time_out[<?= $id ?>]">
                </div>

                <!-- HIDDEN META -->
                <input type="hidden" name="name_arr[<?= $id ?>]"   value="<?= htmlspecialchars($s['full_name']) ?>">
                <input type="hidden" name="role_arr[<?= $id ?>]"   value="<?= htmlspecialchars($s['staff_role']) ?>">
                <input type="hidden" name="type_arr[<?= $id ?>]"   value="<?= htmlspecialchars($s['staff_type']) ?>">
                <input type="hidden" name="table_arr[<?= $id ?>]"  value="<?= htmlspecialchars($s['staff_table']) ?>">
                <input type="hidden" name="code_arr[<?= $id ?>]"   value="<?= htmlspecialchars($s['staff_id']) ?>">
                <input type="hidden" name="late_note[<?= $id ?>]"  id="lateNote<?= $id ?>" value="">
            </div>
            <?php endforeach; ?>

            <div class="text-center mt-4">
                <button name="save_attendance" class="btn btn-primary px-5 py-2">
                    <i class="fa-solid fa-cloud-upload-alt me-1"></i> Submit Attendance
                </button>
            </div>

        </form>
        <?php else: ?>
            <p class="text-muted text-center">No staff found for selected criteria.</p>
        <?php endif; ?>

    </div>
</div>

<?php
include __DIR__ . "/../includes/hospital_scripts.php";
include __DIR__ . "/../includes/hospital_footer.php";
?>

<script>
// convert minutes -> HH:MM
function minToTime(m){
    m = ((m % (24*60)) + (24*60)) % (24*60); // keep in day
    let h = Math.floor(m/60);
    let mm = m%60;
    return String(h).padStart(2,'0') + ':' + String(mm).padStart(2,'0');
}

function setStatus(id,status,btn){
    const row       = document.getElementById('row'+id);
    const statusInp = document.getElementById('status'+id);
    const timeBox   = document.getElementById('timeBox'+id);
    const lateBadge = document.getElementById('lateBadge'+id);
    const lateNote  = document.getElementById('lateNote'+id);
    const dutyFrom  = row.dataset.dutyFrom || '';
    const dutyTo    = row.dataset.dutyTo   || '';

    if(!row || !statusInp) return;
    statusInp.value = status;

    // toggle active class
    row.querySelectorAll('.btn-status').forEach(b=>b.classList.remove('active'));
    btn.classList.add('active');

    const inInput  = timeBox.querySelector('input[name="time_in['+id+']"]');
    const outInput = timeBox.querySelector('input[name="time_out['+id+']"]');

    // For Present & Half Day -> show time box, auto fill
    if(status === 'Present' || status === 'Half Day'){
        timeBox.style.display = 'block';

        if(dutyFrom){
            const now = new Date();
            const nowMin = now.getHours()*60 + now.getMinutes();

            const dfParts = dutyFrom.split(':');
            const dfH = parseInt(dfParts[0] || '0',10);
            const dfM = parseInt(dfParts[1] || '0',10);
            const dutyFromMin = dfH*60 + dfM;

            const gt = 30; // grace = 30 min
            const graceLimit = dutyFromMin + gt;

            let usedIn = dutyFromMin;
            let lateBy = 0;

            if(nowMin > graceLimit){
                usedIn = nowMin;
                lateBy = nowMin - dutyFromMin;
            }

            inInput.value = minToTime(usedIn);

            let dutyToMin;
            if(dutyTo){
                const dtParts = dutyTo.split(':');
                const dtH = parseInt(dtParts[0] || '0',10);
                const dtM = parseInt(dtParts[1] || '0',10);
                dutyToMin = dtH*60 + dtM;
            }else{
                // default 8 hours shift if duty_to not set
                dutyToMin = dutyFromMin + 8*60;
            }

            let usedOut = dutyToMin;

            if(status === 'Half Day'){
                const half = dutyFromMin + Math.floor((dutyToMin - dutyFromMin)/2);
                usedOut = half;
            }

            outInput.value = minToTime(usedOut);

            if(lateBy > 0){
                lateBadge.style.display='inline-block';
                lateBadge.textContent = 'Late ' + lateBy + ' min';
                lateNote.value = 'Late by '+lateBy+' min';
            }else{
                lateBadge.style.display='none';
                lateNote.value = '';
            }

        } else {
            // no duty time set -> clear time, let user enter
            inInput.value  = '';
            outInput.value = '';
            lateBadge.style.display='none';
            lateNote.value = '';
        }

    } else {
        // Absent / Leave => hide times
        timeBox.style.display = 'none';
        inInput.value  = '';
        outInput.value = '';
        lateBadge.style.display='none';
        lateNote.value = '';
    }
}

// Bulk mark
function markAll(status){
    document.querySelectorAll('.row-attendance').forEach(row=>{
        const id = row.dataset.id;
        const btn = row.querySelector('.btn-status[data-status="'+status+'"]');
        if(btn) setStatus(id,status,btn);
    });
}
</script>
