<?php
session_start();

include dirname(__DIR__, 2) . "/config/config.php";
include dirname(__DIR__, 2) . "/config/biometric_process.php";

include __DIR__ . "/../includes/hospital_head.php";
include __DIR__ . "/../includes/hospital_header.php";
include __DIR__ . "/../includes/hospital_sidebar.php";

if (!isset($_SESSION['hospital_id'])) {
    header("Location: ../includes/log/login.php");
    exit;
}

$hospital_id = (int)$_SESSION['hospital_id'];

$selected_date = $_GET['date'] ?? date('Y-m-d');
$selected_role = $_GET['role'] ?? "";

$month_start = date("Y-m-01", strtotime($selected_date));
$month_end   = date("Y-m-t", strtotime($selected_date));

$error = "";
$success = "";

/* ============================
   BIOMETRIC SYNC
=============================*/
if (isset($_GET['sync_biometric'])) {

    $bio = processBiometricLogs($conn, $hospital_id);

    if (isset($bio['error'])) {
        $error = $bio['error'];
    } else {
        $inserted = 0;

        foreach ($bio as $b) {
            $auto_id = (int)$b['auto_id'];
            $adate   = $conn->real_escape_string($b['date']);

            $chk = $conn->query("
                SELECT id FROM attendance
                WHERE hospital_id='$hospital_id'
                AND staff_auto_id='$auto_id'
                AND attendance_date='$adate'
                LIMIT 1
            ");

            if ($chk->num_rows == 0) {

                
                $conn->query("
                    INSERT INTO attendance
                    (hospital_id, full_name, staff_role, staff_type, staff_table,
                    staff_auto_id, staff_id, attendance_date, date, punch_in, punch_out,
                    status, device_name, created_at)
                    VALUES (
                        '$hospital_id',
                        '{$b['name']}',
                        '{$b['role']}',
                        '{$b['role']}',
                        '{$b['table']}',
                        '{$b['auto_id']}',
                        '{$b['staff_code']}',
                        '{$b['date']}',
                        '{$b['date']}',
                        '{$b['time']}',
                        NULL,                      -- punch_out blank for biometric
                        'present',
                        '{$b['device_name']}',
                        NOW()
                    )
                ");
                $inserted++;
            }
        }

        $success = "Biometric sync completed — {$inserted} new records added.";
    }
}

/* ============================
   LOAD STAFF
=============================*/
$staff_map = [];

// Doctors
$d = $conn->query("
    SELECT id, full_name 
    FROM doctors 
    WHERE hospital_id='$hospital_id'
    ORDER BY full_name
");
while ($r = $d->fetch_assoc()) {
    $staff_map[(int)$r['id']] = [
        'name' => $r['full_name'],
        'role' => 'doctor',
        'table'=> 'doctors'
    ];
}

// Staff
$role_sql = $selected_role !== "" ? "AND staff_type='".$conn->real_escape_string($selected_role)."'" : "";

$s = $conn->query("
    SELECT id, full_name, staff_type
    FROM staff_management
    WHERE hospital_id='$hospital_id' $role_sql
    ORDER BY full_name
");

while ($r = $s->fetch_assoc()) {
    if ($selected_role == "doctor") continue;

    $staff_map[(int)$r['id']] = [
        'name' => $r['full_name'],
        'role' => $r['staff_type'],
        'table'=> 'staff_management'
    ];
}

/* ============================
   TODAY ATTENDANCE
=============================*/
$today_map = [];

$t = $conn->query("
    SELECT *
    FROM attendance
    WHERE hospital_id='$hospital_id'
    AND attendance_date='$selected_date'
");

while ($r = $t->fetch_assoc()) {
    $today_map[(int)$r['staff_auto_id']] = $r;
}

/* ============================
   MONTH ATTENDANCE
=============================*/
$attendance_rows = [];

$m = $conn->query("
    SELECT *
    FROM attendance
    WHERE hospital_id='$hospital_id'
    AND attendance_date BETWEEN '$month_start' AND '$month_end'
");

while ($r = $m->fetch_assoc()) {
    $aid = (int)$r['staff_auto_id'];
    if (!isset($attendance_rows[$aid])) $attendance_rows[$aid] = [];
    $attendance_rows[$aid][$r['attendance_date']] = $r;
}

/* ============================
   SUMMARY TODAY
=============================*/
$present = $absent = $leave = $late = 0;

foreach ($staff_map as $aid => $meta) {
    $r = $today_map[$aid] ?? null;

    if (!$r) {
        $absent++;
        continue;
    }

    $s = strtolower($r['status']);

    if ($s === 'present') $present++;
    elseif ($s === 'absent') $absent++;
    elseif ($s === 'leave') $leave++;

    if (!empty($r['punch_in']) && strtotime($r['punch_in']) > strtotime("09:10:00"))
        $late++;
}
?>
<!-- FRONT UI -->
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
/* BOOTSTRAP BADGE FIX - DISABLE DEFAULT COLORS */
.badge {
    background-color: transparent !important;
    border-radius: 6px;
    padding: 4px 10px;
    font-weight: 600;
    display: inline-block;
}

/* CUSTOM COLORS */
.badge-present {
    background: #28a745 !important; 
    color: #fff !important;
}

.badge-absent {
    background: #dc3545 !important; 
    color: #fff !important;
}

.badge-leave {
    background: #ff9800 !important; 
    color: #000 !important;
}

.badge-late {
    background: #ffeb3b !important;
    color: #000 !important;
}

/* neutral small badge for "No" or unknown */
.badge-muted {
    background: #6c757d !important;
    color: #fff !important;
}

/* Late row highlight */
.late-highlight {
    background: #fff7c2 !important;
}

/* Layout */
.content-wrapper { margin-left:250px!important; padding:25px; background:#f4f7fe; }
.table thead th { background:#0d6efd; color:white; }
.summary-box { background:white; padding:18px; border-radius:10px; text-align:center; }

/* Make modal print area clean */
@media print {
  body * { visibility: hidden; }
  .print-area, .print-area * { visibility: visible; }
}
</style>

<div class="content-wrapper">
<div class="container-fluid">

<h3 class="fw-bold mb-4"><i class="fa-solid fa-eye me-2"></i> View Attendance — <?= date("d M Y", strtotime($selected_date)) ?></h3>

<!-- MONTHLY REPORT PAGE BUTTON -->
<div class="mb-3 d-flex gap-2">

    <!-- MONTHLY REPORT (Yellow Button) -->
    <a href="<?php echo MENU_PATH; ?>attendance/monthly_report.php" class="btn btn-warning">
        <i class="fa-solid fa-chart-line me-1"></i> Monthly Report
    </a>

    <!-- TAKE ATTENDANCE (Exact Same Design) -->
    <a href="<?php echo MENU_PATH; ?>attendance/take_attendance.php" class="btn btn-warning">
        <i class="fa-solid fa-user-check me-1"></i> Take Attendance
    </a>

</div>


<?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
<?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>

<!-- FILTER -->
<form class="row g-3 mb-4" method="GET">
    <div class="col-md-3">
        <label class="fw-semibold">Select Date</label>
        <input type="date" name="date" class="form-control" value="<?= htmlspecialchars($selected_date) ?>">
    </div>

    <div class="col-md-3">
        <label class="fw-semibold">Role</label>
        <select name="role" class="form-select">
            <option value="">All</option>
            <option value="doctor" <?= $selected_role=="doctor"?"selected":"" ?>>Doctor</option>
            <?php
            $rs = $conn->query("SELECT DISTINCT staff_type FROM staff_management WHERE hospital_id='$hospital_id'");
            while ($r = $rs->fetch_assoc()):
            ?>
            <option value="<?= htmlspecialchars($r['staff_type']) ?>" <?= $selected_role==$r['staff_type']?"selected":"" ?>>
                <?= ucfirst(htmlspecialchars($r['staff_type'])) ?>
            </option>
            <?php endwhile; ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="fw-semibold">Biometric Sync</label>
        <button name="sync_biometric" value="1" class="btn btn-dark w-100">
            <i class="fa-solid fa-fingerprint me-1"></i> Sync Now
        </button>
    </div>

    <div class="col-md-3 d-flex align-items-end">
        <button class="btn btn-primary w-100"><i class="fa-solid fa-search me-1"></i> Search</button>
    </div>
</form>


<!-- SUMMARY BOX -->
<div class="row g-3 mb-4">
    <div class="col-md-3"><div class="summary-box">Present: <span class="badge badge-present"><?= $present ?></span></div></div>
    <div class="col-md-3"><div class="summary-box">Absent: <span class="badge badge-absent"><?= $absent ?></span></div></div>
    <div class="col-md-3"><div class="summary-box">Leave: <span class="badge badge-leave"><?= $leave ?></span></div></div>
    <div class="col-md-3"><div class="summary-box">Late: <span class="badge badge-late"><?= $late ?></span></div></div>
</div>


<!-- TODAY TABLE -->
<div class="table-responsive">
<table class="table table-bordered table-hover align-middle">
<thead>
<tr>
    <th style="width:60px;">Sr.No</th>
    <th>Name</th>
    <th style="width:110px;">IN</th>
    <th style="width:110px;">OUT</th>
    <th style="width:120px;">Status</th>
    <th style="width:90px;">Late</th>
    <th style="width:140px;">Device</th>
    <th style="width:100px;">Details</th>
</tr>
</thead>

<tbody>
<?php $i=1; foreach ($staff_map as $aid => $meta):

    $r = $today_map[$aid] ?? null;

    if ($r) {
        $status = $r['status'];
        $in = $r['punch_in'] ?: "-";
        $out = $r['punch_out'] ?: "-";
        $dev = $r['device_name'] ?: "-";
    } else {
        $status = "absent";
        $in = "-";
        $out = "-";
        $dev = "-";
    }

    $isLate = ($in!=="-" && strtotime($in) > strtotime("09:10:00"));
?>
<tr class="<?= $isLate ? 'late-highlight' : '' ?>">
    <td><?= $i++ ?></td>
    <td>
        <?= htmlspecialchars($meta['name']) ?><br>
        <small class="text-muted"><?= htmlspecialchars($meta['role']) ?></small>
    </td>
    <td><?= htmlspecialchars($in) ?></td>
    <td><?= htmlspecialchars($out) ?></td>

    <!-- STATUS with explicit colored badges -->
    <td>
    <?php 
        $sts = strtolower($status); // convert to lowercase safely
        
        if ($sts === "present"): ?>
            <span class="badge badge-present">Present</span>

        <?php elseif ($sts === "absent"): ?>
            <span class="badge badge-absent">Absent</span>

        <?php elseif ($sts === "leave"): ?>
            <span class="badge badge-leave">Leave</span>

        <?php elseif ($sts === "late"): ?>
            <span class="badge badge-late">Late</span>

        <?php else: ?>
            <span class="badge badge-muted"><?= ucfirst(htmlspecialchars($status)) ?></span>
    <?php endif; ?>
</td>


    <!-- LATE -->
    <td>
        <?= $isLate 
            ? "<span class='badge badge-late'>Yes</span>" 
            : "<span class='badge badge-muted'>No</span>" ?>
    </td>

    <td><?= htmlspecialchars($dev) ?></td>
    <td>
        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#d<?= (int)$aid ?>">View</button>
    </td>
</tr>

<?php endforeach; ?>
</tbody>
</table>
</div>


<!-- MODALS -->
<?php foreach ($staff_map as $aid => $meta):

$rows = $attendance_rows[$aid] ?? [];
$period = new DatePeriod(new DateTime($month_start), new DateInterval("P1D"), (new DateTime($month_end))->modify("+1 day"));
?>

<div class="modal fade" id="d<?= (int)$aid ?>" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title"><?= htmlspecialchars($meta['name']) ?> — <?= date("F Y", strtotime($selected_date)) ?></h5>
        <button class="btn btn-primary btn-sm me-2" onclick="printModal('body<?= (int)$aid ?>')">Print</button>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body print-area" id="body<?= (int)$aid ?>">

        <div class="table-responsive">
        <table class="table table-bordered">
        <thead>
            <tr>
                <th>Date</th>
                <th>Status</th>
                <th>IN</th>
                <th>OUT</th>
                <th>Device</th>
            </tr>
        </thead>

        <tbody>
        <?php foreach ($period as $dt):
            $d = $dt->format("Y-m-d");
            $r = $rows[$d] ?? null;
        ?>
        <tr>
            <td><?= $d ?></td>
            <td><?= isset($r['status']) ? htmlspecialchars($r['status']) : "-" ?></td>

            <!-- FIXED IN & OUT -->
            <td><?= (!empty($r['punch_in'])  ? htmlspecialchars($r['punch_in'])  : "-") ?></td>
            <td><?= (!empty($r['punch_out']) ? htmlspecialchars($r['punch_out']) : "-") ?></td>

            <td><?= isset($r['device_name']) ? htmlspecialchars($r['device_name']) : "-" ?></td>
        </tr>
        <?php endforeach; ?>
        </tbody>
        </table>
        </div>

      </div>

    </div>
  </div>
</div>

<?php endforeach; ?>


<?php
include_once __DIR__ . "/../includes/hospital_scripts.php";
include_once __DIR__ . "/../includes/hospital_footer.php";
?>


</div>
</div>
