<?php
session_start();
include $_SERVER['DOCUMENT_ROOT']."/multi_hospital2/config/config.php";

if(!isset($_SESSION['hospital_id'])){ header("Location: ../../login/hospital_login.php"); exit; }

$hospital_id=$_SESSION['hospital_id'];
$msg="";

/* ========= INSERT SPECIALIZATION ========= */
if(isset($_POST['add'])){
    $name=trim($_POST['specialization']);
    $desc=trim($_POST['description']);

    if($name!=""){
        $chk=$conn->query("SELECT id FROM specializations WHERE hospital_id='$hospital_id' AND specialization_name='$name'");
        
        if($chk->num_rows>0){ $msg="⚠ Already exists!"; }
        else{
            $conn->query("INSERT INTO specializations(hospital_id,specialization_name,description) 
                          VALUES('$hospital_id','$name','$desc')");
            $msg="✔ Specialization Added Successfully";
        }
    }
}

/* ========= DELETE SPECIALIZATION ========= */
if(isset($_GET['del'])){
    $id=(int)$_GET['del'];
    $conn->query("DELETE FROM specializations WHERE id='$id' AND hospital_id='$hospital_id'");
    $msg="🗑 Deleted Successfully";
}

/* ========= UPDATE SPECIALIZATION ========= */
if(isset($_POST['update'])){
    $id=$_POST['edit_id'];
    $name=$_POST['edit_name'];
    $desc=$_POST['edit_desc'];
    $conn->query("UPDATE specializations SET specialization_name='$name',description='$desc' 
                  WHERE id='$id' AND hospital_id='$hospital_id'");
    $msg="✏ Updated Successfully";
}

/* Fetch All */
$data=$conn->query("SELECT * FROM specializations WHERE hospital_id='$hospital_id' ORDER BY specialization_name ASC");


include "../../includes/hospital_head.php";
include "../../includes/hospital_header.php";
include "../../includes/hospital_sidebar.php";
?>

<style>
.content-wrapper{
    margin-left:260px!important;
    padding:35px;background:#eef3fa;min-height:100vh;
}
.card{border-radius:12px;box-shadow:0 2px 10px rgba(0,0,0,.08);}
.table td{text-transform:capitalize;}
</style>

<div class="content-wrapper">

<div class="card p-4 mb-3">
    <h3 class="fw-bold mb-1"><i class="fa-solid fa-stethoscope me-2"></i>Doctor Specializations</h3>
    <small class="text-muted">Add • View • Edit • Delete</small>
</div>

<?php if($msg){ ?><div class="alert alert-info"><?=$msg?></div><?php } ?>

<!-- ================== ADD FORM ================== -->
<div class="card p-4 mb-4">
    <form method="POST" class="row g-3">

        <div class="col-md-5">
            <label class="fw-semibold">Specialization Name</label>
            <input type="text" name="specialization" class="form-control" placeholder="Ex : Cardiologist" required>
        </div>

        <div class="col-md-5">
            <label class="fw-semibold">Description (optional)</label>
            <input type="text" name="description" class="form-control" placeholder="Details about specialization...">
        </div>

        <div class="col-md-2 d-flex align-items-end">
            <button name="add" class="btn btn-primary w-100">
                <i class="fa fa-plus"></i> Add
            </button>
        </div>

    </form>
</div>

<!-- ================== TABLE LIST ================== -->
<div class="card p-4">
    <h5 class="fw-bold mb-3">Specialization List</h5>

    <table class="table table-bordered table-striped text-center">
        <thead class="table-primary">
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Details</th>
                <th>Created</th>
                <th width="160">Actions</th>
            </tr>
        </thead>
        <tbody>

        <?php $i=1; while($row=$data->fetch_assoc()): ?>
        <tr>
            <td><?=$i++?></td>
            <td><?=$row['specialization_name']?></td>
            <td><?=$row['description']?></td>
            <td><?=$row['created_at']?></td>
            <td>
                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#edit<?=$row['id']?>">Edit</button>
                <a onclick="return confirm('Delete this specialization?')" 
                   href="?del=<?=$row['id']?>" class="btn btn-danger btn-sm">Delete</a>
            </td>
        </tr>

        <!-- ========= EDIT MODAL ========= -->
        <div class="modal fade" id="edit<?=$row['id']?>">
        <div class="modal-dialog">
        <div class="modal-content">

            <form method="POST">
            <div class="modal-header bg-warning">
                <strong>Edit Specialization</strong>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <input type="hidden" name="edit_id" value="<?=$row['id']?>">
                
                <label class="fw-semibold">Name</label>
                <input type="text" name="edit_name" class="form-control mb-2" value="<?=$row['specialization_name']?>" required>

                <label class="fw-semibold">Description</label>
                <input type="text" name="edit_desc" class="form-control" value="<?=$row['description']?>">
            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button name="update" class="btn btn-warning">Update</button>
            </div>
            </form>

        </div>
        </div>
        </div>

        <?php endwhile; ?>
        </tbody>
    </table>
</div>
</div>

<?php include "../../includes/hospital_footer.php"; ?>
<?php include "../../includes/hospital_scripts.php"; ?>
