<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'] . '/multi_hospital2/config/config.php';

if(!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']) {
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

$upload_dir = $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/uploads/doctors/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

function generateStaffID($prefix = "DOC") {
    return $prefix . date('YmdHis');
}

if($_SERVER['REQUEST_METHOD'] == 'POST') {

    $staff_type      = $_POST['staff_type'];
    $prefix_map      = [ "Doctor" => "DOC" ];
    $prefix          = $prefix_map[$staff_type];
    $staff_id        = generateStaffID($prefix);

    $full_name       = $_POST['full_name'];
    $email           = $_POST['email'];
    $phone           = $_POST['phone'];
    $gender          = $_POST['gender'];
    $dob             = $_POST['dob'];
    $qualification   = $_POST['qualification'];
    $specialization  = $_POST['specialization'];
    $salary          = $_POST['salary'];
    $joining_date    = $_POST['joining_date'];
    $status          = $_POST['status'];
    $experience_years   = $_POST['experience_years'];
    $experience_details = $_POST['experience_details'];
    $password        = password_hash("123456", PASSWORD_DEFAULT);

    // PROFILE PHOTO
    $profile_photo_name = "";
    if(isset($_FILES['profile_photo']) && $_FILES['profile_photo']['error'] == 0){
        $ext = pathinfo($_FILES['profile_photo']['name'], PATHINFO_EXTENSION);
        $profile_photo_name = "staff_".time()."_profile.".$ext;
        move_uploaded_file($_FILES['profile_photo']['tmp_name'], $upload_dir.$profile_photo_name);
    }

    // DOCUMENTS
    $documents_names = [];
    if(isset($_FILES['documents'])){
        foreach($_FILES['documents']['tmp_name'] as $key => $tmp_name){
            if($_FILES['documents']['error'][$key] == 0){
                $ext = pathinfo($_FILES['documents']['name'][$key], PATHINFO_EXTENSION);
                $doc_name = "staff_".time()."_".$key.".".$ext;
                move_uploaded_file($tmp_name, $upload_dir.$doc_name);
                $documents_names[] = $doc_name;
            }
        }
    }
    $documents = implode(",", $documents_names);

    // INSERT QUERY
    $stmt = $conn->prepare("INSERT INTO doctors 
    (hospital_id, staff_id, staff_type, full_name, specialization, phone, email, password, gender, dob, qualification, salary, joining_date, status, profile_photo, documents, experience_years, experience_details)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

    $stmt->bind_param("isssssssssssdsssiss", 
        $hospital_id, $staff_id, $staff_type, $full_name, $specialization,
        $phone, $email, $password, $gender, $dob, $qualification,
        $salary, $joining_date, $status, $profile_photo_name, $documents,
        $experience_years, $experience_details
    );

    if($stmt->execute()) {
        header("Location: view_doctor_list.php?success=1");
        exit;
    } else {
        $msg = "<div class='alert alert-danger'>Error: " . $stmt->error . "</div>";
    }
}
?>

<?php include '../includes/hospital_head.php'; ?>
<?php include '../includes/hospital_header.php'; ?> 
<?php include '../includes/hospital_sidebar.php'; ?> 

<style>
.content-wrapper { margin-left:260px; padding:28px; }
.form-container { max-width:1150px; margin:auto; }
.form-card { background:#fff; padding:35px; border-radius:14px; box-shadow:0 4px 18px rgba(0,0,0,0.07); }
.form-title { font-size:26px; font-weight:700; color:#003c71; }
.form-sub { font-size:14px; color:#777; margin-bottom:25px; }

.form-grid {
    display:grid;
    grid-template-columns:1fr 1fr;
    gap:22px 40px;
}
@media(max-width:768px){ .form-grid{ grid-template-columns:1fr; } }

.form-group { display:flex; flex-direction:column; }
label { font-weight:600; margin-bottom:6px; }
.required::after{ content:" *"; color:#d63384; }

.form-control, .form-select {
    height:48px !important;
    border-radius:8px;
    padding:10px;
    border:1px solid #cfd7e3;
}
textarea.form-control{ height:auto !important; }

.form-control:focus, .form-select:focus {
    border-color:#0d6efd;
    box-shadow:0 0 0 2px rgba(13,110,253,0.18);
}
</style>

<div class="content-wrapper">
    <div class="form-container">
        <div class="form-card">

            <h3 class="form-title">Add Doctor</h3>
            <p class="form-sub">Fill all required information</p>

            <?php if(isset($msg)) echo $msg; ?>

            <form method="POST" enctype="multipart/form-data">

                <input type="hidden" name="staff_type" value="Doctor">

                <div class="form-grid">

                    <div class="form-group">
                        <label class="required">Doctor Name</label>
                        <input type="text" name="full_name" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="required">Specialization</label>
                        <select name="specialization" class="form-select" required>
                            <option disabled selected>Select specialization</option>
                            <?php
                            $res = $conn->query("SELECT * FROM specializations WHERE hospital_id='$hospital_id'");
                            while($row = $res->fetch_assoc()):
                            ?>
                            <option value="<?= $row['specialization_name'] ?>"><?= $row['specialization_name'] ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label class="required">Email</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="required">Phone</label>
                        <input type="text" name="phone" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="required">Gender</label>
                        <select name="gender" class="form-select" required>
                            <option disabled selected>Select gender</option>
                            <option>Male</option>
                            <option>Female</option>
                            <option>Other</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label class="required">Date of Birth</label>
                        <input type="date" name="dob" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="required">Qualification</label>
                        <input type="text" name="qualification" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="required">Salary</label>
                        <input type="number" name="salary" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="required">Joining Date</label>
                        <input type="date" name="joining_date" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="required">Status</label>
                        <select name="status" class="form-select">
                            <option>Active</option>
                            <option>Inactive</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Profile Photo</label>
                        <input type="file" name="profile_photo" class="form-control">
                    </div>

                    <div class="form-group">
                        <label>Documents</label>
                        <input type="file" name="documents[]" multiple class="form-control">
                    </div>

                    <!-- ⭐ EXPERIENCE FIELDS -->
                    <div class="form-group">
                        <label class="required">Experience (Years)</label>
                        <input type="number" name="experience_years" class="form-control" required>
                    </div>

                    <div class="form-group" style="grid-column: span 2;">
                        <label class="required">Experience Details</label>
                        <textarea name="experience_details" class="form-control" rows="3" required></textarea>
                    </div>

                </div>

                <div class="text-end mt-4">
                    <button type="reset" class="btn btn-outline-secondary">Reset</button>
                    <button type="submit" class="btn btn-primary">Add Doctor</button>
                </div>

            </form>

        </div>
    </div>
</div>

<?php include '../includes/hospital_scripts.php'; ?>
</body>
</html>
