<?php
require_once __DIR__ . '/../../../config/config.php';

// start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// include head
require_once __DIR__ . '/../../includes/hospital_head.php';
?>

<style>
    body { background:#f5f7fb; }

    .content-wrapper {
        margin-left:260px !important;    /* sidebar width */
        margin-top:90px !important;      /* header height */
        padding:20px;
        min-height:100vh;
    }

    .card-modern {
        background:white;
        border-radius:10px;
        padding:20px;
        box-shadow:0 3px 10px rgba(0,0,0,0.1);
    }
</style>

<body>

<?php
require_once __DIR__ . '/../../includes/hospital_header.php';
require_once __DIR__ . '/../../includes/hospital_sidebar.php';
?>

<div class="content-wrapper">

    <h3 class="mb-3">Doctor Availability</h3>

<?php
// SPECIALIZATIONS (department ki jagah)
$specializations = $conn->query("SELECT specialization_name FROM specializations");

// DOCTOR LIST
$doctor_list = $conn->query("SELECT full_name FROM doctors ORDER BY full_name ASC");

// FILTER CONDITIONS
$where = " WHERE 1=1 ";

if (!empty($_GET['specialization'])) {
    $spec = $_GET['specialization'];
    $where .= " AND d.specialization = '$spec' ";
}

if (!empty($_GET['doctor'])) {
    $doc = $_GET['doctor'];
    $where .= " AND d.full_name = '$doc' ";
}

$doctors = $conn->query("
    SELECT d.*, sc.*
    FROM doctors d
    LEFT JOIN schedule sc ON sc.staff_id = d.staff_id
    $where
    ORDER BY d.full_name ASC
");


// days
$days = ["Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"];
?>

    <!-- FILTER BAR -->
    <div class="card-modern mb-4">
        <form method="GET" class="row g-3">

            <div class="col-md-4">
                <label class="small-muted">Specialization</label>
                <select name="specialization" class="form-select">
                    <option value="">All Specializations</option>
                    <?php while($s = $specializations->fetch_assoc()){ ?>
                        <option value="<?= $s['specialization_name'] ?>">
                            <?= $s['specialization_name'] ?>
                        </option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-md-4">
                <label class="small-muted">Doctor</label>
                <select name="doctor" class="form-select">
                    <option value="">All Doctors</option>
                    <?php while($dr = $doctor_list->fetch_assoc()){ ?>
                        <option><?= $dr['full_name'] ?></option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-md-2">
                <label>&nbsp;</label>
                <button class="btn btn-primary w-100">Search</button>
            </div>

        </form>
    </div>

    <!-- TODAY STATUS -->
    <div class="card-modern mb-4">
        <h5 class="mb-3">Today's Availability</h5>

        <table class="table table-bordered text-center">
            <thead class="table-light">
                <tr>
                    <th>Doctor</th>
                    <th>Specialization</th>
                    <th>Status Today</th>
                    <th>Available Time</th>
                </tr>
            </thead>
            <tbody>

                <?php
                $today = strtolower(date("l")); // monday_start format

                mysqli_data_seek($doctors, 0);
                while ($row = $doctors->fetch_assoc()) {

                    $from = $row[$today."_start"];
                    $to   = $row[$today."_end"];

                    if ($from && $to)       $status = "<span class='badge bg-success'>Available</span>";
                    else                    $status = "<span class='badge bg-danger'>Not Available</span>";
                ?>

                <tr>
                    <td><?= $row['full_name'] ?></td>
                    <td><?= $row['specialization'] ?></td>
                    <td><?= $status ?></td>
                    <td><?= ($from) ? "$from - $to" : "N/A" ?></td>
                </tr>

                <?php } ?>

            </tbody>
        </table>
    </div>

    <!-- WEEKLY TABLE -->
    <div class="card-modern">
        <h5 class="mb-3">Weekly Availability Calendar</h5>

        <table class="table table-bordered text-center">
            <thead class="table-light">
                <tr>
                    <th>Doctor</th>
                    <?php foreach ($days as $d) echo "<th>$d</th>"; ?>
                </tr>
            </thead>

            <tbody>

                <?php
                mysqli_data_seek($doctors, 0);
                while ($dr = $doctors->fetch_assoc()) {

                    echo "<tr>";
                    echo "<td>{$dr['full_name']}</td>";

                    foreach ($days as $d) {

                        $d_lower = strtolower($d);

                        $start = $dr[$d_lower."_start"];
                        $end   = $dr[$d_lower."_end"];

                        if ($start && $end)
                            echo "<td><span class='badge bg-success'>Available</span><br>$start - $end</td>";
                        else
                            echo "<td><span class='badge bg-secondary'>N/A</span></td>";
                    }

                    echo "</tr>";
                }
                ?>

            </tbody>
        </table>
    </div>

</div>

<?php
// ⭐ CORRECT SCRIPT PATH ⭐
include __DIR__ . '/../../includes/hospital_script.php';
?>

</body>
</html>
