<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

if(!isset($_SESSION['hospital_logged_in'])){
    header("Location: ../../login/hospital_login.php");
    exit;
}

if(!isset($_GET['doctor_id'])){
    die("Invalid request");
}

$doctor_id = intval($_GET['doctor_id']);

/* Fetch doctor name */
$doc = $conn->query("
    SELECT full_name 
    FROM doctors 
    WHERE id='$doctor_id'
")->fetch_assoc();

/* Fetch suspend history */
$res = $conn->query("
    SELECT *
    FROM doctor_suspend_list
    WHERE doctor_id='$doctor_id'
    ORDER BY id DESC
");
?>

<?php include '../../includes/hospital_head.php'; ?>
<?php include '../../includes/hospital_header.php'; ?>
<?php include '../../includes/hospital_sidebar.php'; ?>

<style>
/* ================= PAGE ================= */
.content-wrapper{
    margin-left:260px;
    padding:30px;
    padding-top:95px;
    background:#eef3fa;
    min-height:100vh;
}

/* ================= CARD ================= */
.card{
    background:#fff;
    border-radius:12px;
    box-shadow:0 8px 25px rgba(0,0,0,0.08);
    border:none;
    padding:22px;
}

/* ================= TITLE ================= */
.page-title{
    font-size:26px;
    font-weight:700;
    margin-bottom:10px;
}

/* ================= BUTTON ================= */
.action-btn-box{
    margin-bottom:18px;
}
.print-btn{
    background:#000;
    color:#fff;
    padding:8px 16px;
    border-radius:6px;
    border:none;
    font-weight:600;
}

/* ================= TABLE ================= */
.table th{
    background:#f8d7da;
    text-align:center;
}
.table td{
    text-align:center;
    vertical-align:middle;
}

/* ================= PRINT ================= */
.print-title{
    display:none;
    font-size:22px;
    font-weight:700;
    text-align:center;
    margin-bottom:15px;
}

.list-btn{
   background:#0066ff;
   color:#fff;
   padding:9px 18px;
   border-radius:6px;
   text-decoration:none;
   font-weight:600;
   }

@media print{
    body *{ visibility:hidden !important; }
    .print-area, .print-area *{ visibility:visible !important; }
    .print-area{
        position:absolute;
        left:0;
        top:0;
        width:100%;
    }
    .print-title{ display:block !important; }

    header,.sidebar,.action-btn-box,.btn{
        display:none!important;
    }
}
</style>

<div class="content-wrapper">

    <!-- 🔥 CARD + PRINT AREA SAME (IMPORTANT) -->
    <div class="card print-area">

        <h4 class="page-title">
            <i class="fa fa-clock-rotate-left text-primary me-2"></i>
            Suspend History – <?= htmlspecialchars($doc['full_name'] ?? 'Doctor') ?>
        </h4>

        <div class="action-btn-box">
            <button onclick="window.print()" class="print-btn">🖨 Print H</button>
            <a href="<?php echo MENU_PATH; ?>doctor/view_doctor_list.php" class="list-btn">📋 Doctor List</a>
        </div>

        

        <!-- PRINT TITLE -->
        <h3 class="print-title">
            Suspend History – <?= htmlspecialchars($doc['full_name'] ?? 'Doctor') ?>
        </h3>

        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Reason</th>
                        <th>Suspended On</th>
                        <th>Restored On</th>
                    </tr>
                </thead>

                <tbody>
                <?php
                $i = 1;
                while($r = $res->fetch_assoc()):
                ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td><?= date("d M Y", strtotime($r['from_date'])); ?></td>
                        <td><?= date("d M Y", strtotime($r['to_date'])); ?></td>
                        <td><?= htmlspecialchars($r['reason']); ?></td>
                        <td><?= date("d M Y h:i A", strtotime($r['suspended_on'])); ?></td>
                        <td>
                            <?= $r['restored_on']
                                ? date("d M Y h:i A", strtotime($r['restored_on']))
                                : '<span class="text-muted">---</span>'; ?>
                        </td>
                    </tr>
                <?php endwhile; ?>

                <?php if($res->num_rows == 0): ?>
                    <tr>
                        <td colspan="6" class="text-muted">
                            No suspension history found
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

<?php include '../../includes/hospital_scripts.php'; ?>
