<?php
   session_start();
   include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';
   
   if(!isset($_SESSION['hospital_logged_in'])){
       header("Location: ../../login/hospital_login.php");
       exit;
   }
   
   $hospital_id = $_SESSION['hospital_id'];
   
   $query = $conn->query("
SELECT s.*, d.full_name, d.phone, d.profile_photo
FROM doctor_suspend_list s
JOIN doctors d ON s.doctor_id = d.id
JOIN (
    SELECT doctor_id, MAX(id) AS max_id
    FROM doctor_suspend_list
    WHERE hospital_id='$hospital_id'
    GROUP BY doctor_id
) latest ON latest.max_id = s.id
ORDER BY s.id DESC
");


   ?>
<?php include '../../includes/hospital_head.php'; ?>
<?php include '../../includes/hospital_header.php'; ?>
<?php include '../../includes/hospital_sidebar.php'; ?>
<style>
   /* ================= PAGE ================= */
   .content-wrapper{
   margin-left:260px;
   padding:30px;
   padding-top:95px;
   background:#eef3fa;
   min-height:100vh;
   }
   /* ================= CARD ================= */
   .card-custom{
   border-radius:12px;
   box-shadow:0 8px 25px rgba(0,0,0,0.08);
   border:none;
   }
   /* ================= TITLE ================= */
   .page-title{
   font-size:28px;
   font-weight:bold;
   margin-bottom:15px;
   }
   /* ================= BUTTONS ================= */
   .action-btn-box{
   display:flex;
   gap:12px;
   margin-bottom:18px;
   }
   .print-btn{
   background:#000;
   color:#fff;
   padding:9px 18px;
   border-radius:6px;
   border:none;
   font-weight:600;
   }
   .list-btn{
   background:#0066ff;
   color:#fff;
   padding:9px 18px;
   border-radius:6px;
   text-decoration:none;
   font-weight:600;
   }
   /* ================= TABLE ================= */
   .table thead th{
   background:#f8d7da;
   text-align:center;
   vertical-align:middle;
   }
   .table td{
   vertical-align:middle;
   text-align:center;
   }
   /* ================= PHOTO ================= */
   .avatar{
   width:45px;
   height:45px;
   border-radius:50%;
   object-fit:cover;
   border:1px solid #ddd;
   }
   /* ================= STATUS ================= */
   .badge-suspended{
   background:#ff9800;
   color:#fff;
   padding:6px 14px;
   border-radius:6px;
   }
   .badge-expired{
   background:#28a745;
   color:#fff;
   padding:6px 14px;
   border-radius:6px;
   }
   .badge-restored{
   background:#0d6efd;
   color:#fff;
   padding:6px 14px;
   border-radius:6px;
   }
   /* ================= PRINT (FINAL FIX) ================= */
   @media print {
   /* hide EVERYTHING */
   body * {
   display: none !important;
   }
   /* show ONLY print-area */
   .print-area,
   .print-area * {
   display: block !important;
   }
   /* reset layout */
   .print-area{
   position: absolute;
   left: 0;
   top: 0;
   width: 100%;
   padding: 15px;
   background: #fff;
   }
   /* title */
   .print-title{
   display: block !important;
   font-size: 20px;
   font-weight: 600;
   text-align: center;
   margin-bottom: 15px;
   }
   /* table */
   table{
   width: 100% !important;
   border-collapse: collapse !important;
   }
   th, td{
   font-size: 12px !important;
   padding: 6px !important;
   border: 1px solid #000 !important;
   }
   }
</style>
<div class="content-wrapper">
   <div class="card card-custom">
      <div class="card-body">
         <h4 class="page-title">
            <i class="fa fa-user-doctor text-primary me-2"></i>
            Suspended Doctors Report
         </h4>
         <div class="action-btn-box">
            <button onclick="window.print()" class="print-btn">🖨 Print List</button>
            <a href="<?php echo MENU_PATH; ?>doctor/view_doctor_list.php" class="list-btn">📋 Doctor List</a>
         </div>
         <!-- ================= PRINT AREA ================= -->
         <div class="print-area">
            <h3 class="print-title" style="display:none;">
               Suspended Doctors Report
            </h3>
            <div class="table-responsive">
               <table class="table table-bordered align-middle">
                  <thead>
                     <tr>
                        <th>Photo</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Issue Date</th>
                        <th>From - To</th>
                        <th>Reason</th>
                        <th>Restored On</th>
                        <th>Status</th>
                        <th>Action</th>

                     </tr>
                  </thead>
                  <tbody>
                     <?php while($row=$query->fetch_assoc()):
                        $expired = (strtotime($row['to_date']) < time()) && !$row['restored_on'];
                        $status = $row['restored_on'] ? "Restored" : ($expired ? "Expired" : "Suspended");
                        ?>
                     <tr>
                        <td>
                           <img src="/multi_hospital2/uploads/doctors/<?= $row['profile_photo'] ?: 'default.png' ?>"
                              class="avatar">
                        </td>
                        <td><strong><?= $row['full_name'] ?></strong></td>
                        <td><?= $row['phone'] ?></td>
                        <td><?= date("d M Y h:i A", strtotime($row['suspended_on'])) ?></td>
                        <td>
                           <strong><?= date("d M Y",strtotime($row['from_date'])) ?></strong><br>
                           <strong><?= date("d M Y",strtotime($row['to_date'])) ?></strong>
                        </td>
                        <td><?= $row['reason'] ?></td>
                        <td>
                           <?= $row['restored_on']
                              ? date("d M Y h:i A",strtotime($row['restored_on']))
                              : '---' ?>
                        </td>
                        <td>
                           <?php
                              if($status=="Restored"){
                                  echo "<span class='badge-restored'>Restored</span>";
                              }elseif($status=="Expired"){
                                  echo "<span class='badge-expired'>Expired</span>";
                              }else{
                                  echo "<span class='badge-suspended'>Suspended</span>";
                              }
                              ?>
                        </td>
                        <td>
                            <div class="dropdown no-print">
                                <button class="btn btn-primary btn-sm dropdown-toggle"
                                        data-bs-toggle="dropdown">
                                    Action
                                </button>
                                <ul class="dropdown-menu">

                                    <?php if($status!="Restored"): ?>
                                    <li>
                                        <a class="dropdown-item text-success"
                                        href="dr_restore.php?id=<?= $row['doctor_id'] ?>">
                                            Restore
                                        </a>
                                    </li>
                                    <?php endif; ?>

                                    <li>
                                        <a class="dropdown-item text-info"
                                        href="dr_history_page.php?doctor_id=<?= $row['doctor_id'] ?>"
                                        target="_blank">
                                            History
                                        </a>
                                    </li>

                                </ul>
                            </div>
                        </td>

                     </tr>
                     <?php endwhile; ?>
                  </tbody>
               </table>
            </div>
         </div>
         <!-- ================= END PRINT AREA ================= -->
      </div>
   </div>
</div>
<?php include '../../includes/hospital_scripts.php'; ?>