<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'] . '/multi_hospital2/config/config.php';

if(!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']){
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];
$upload_dir  = $_SERVER['DOCUMENT_ROOT'] . '/multi_hospital2/uploads/doctors/';

/* ================= UPDATE DOCTOR ================= */
if(isset($_POST['update_doctor'])){

    $doctor_id      = $_POST['doctor_id'];
    $full_name      = $_POST['full_name'];
    $email          = $_POST['email'];
    $phone          = $_POST['phone'];
    $gender         = $_POST['gender'];
    $dob            = $_POST['dob'];
    $qualification  = $_POST['qualification'];
    $specialization = $_POST['specialization'];
    $salary         = $_POST['salary'];
    $joining_date   = $_POST['joining_date'];
    $status         = $_POST['status'];
    $experience_years   = $_POST['experience_years'];
    $experience_details = $_POST['experience_details'];

    // PROFILE PHOTO
    $profile_photo_name = $_POST['existing_photo'] ?? '';
    if(isset($_FILES['profile_photo']) && $_FILES['profile_photo']['name'] != ''){
        $profile_photo_name = 'doctor_' . time() . '_' . $_FILES['profile_photo']['name'];
        move_uploaded_file($_FILES['profile_photo']['tmp_name'], $upload_dir.$profile_photo_name);
    }

    // DOCUMENTS
    $documents = $_POST['existing_documents'] ?? '';
    if(isset($_FILES['documents']) && $_FILES['documents']['name'][0] != ''){
        $doc_arr = [];
        foreach($_FILES['documents']['tmp_name'] as $k=>$tmp){
            if($_FILES['documents']['error'][$k]==0){
                $doc_name = 'doc_' . time().'_'.$k.'.'.pathinfo($_FILES['documents']['name'][$k], PATHINFO_EXTENSION);
                move_uploaded_file($tmp, $upload_dir.$doc_name);
                $doc_arr[] = $doc_name;
            }
        }
        if(!empty($doc_arr)){
            $documents = implode(",", $doc_arr);
        }
    }

    $sql = "UPDATE doctors SET
        full_name=?,
        specialization=?,
        phone=?,
        email=?,
        gender=?,
        dob=?,
        qualification=?,
        salary=?,
        joining_date=?,
        status=?,
        profile_photo=?,
        documents=?,
        experience_years=?,
        experience_details=?
        WHERE id=? AND hospital_id=?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "ssssssssssssissii",
        $full_name,
        $specialization,
        $phone,
        $email,
        $gender,
        $dob,
        $qualification,
        $salary,
        $joining_date,
        $status,
        $profile_photo_name,
        $documents,
        $experience_years,
        $experience_details,
        $doctor_id,
        $hospital_id
    );
    $stmt->execute();
    $stmt->close();

    header("Location: view_doctor_list.php?success=1");
    exit;
}

/* ================= FETCH DOCTOR ================= */
if(!isset($_GET['id'])) die("Doctor ID missing");

$doctor_id = $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM doctors WHERE id=? AND hospital_id=?");
$stmt->bind_param("ii", $doctor_id, $hospital_id);
$stmt->execute();
$res = $stmt->get_result();
if($res->num_rows==0) die("Doctor not found");
$doctor = $res->fetch_assoc();
$stmt->close();
?>

<?php include '../includes/hospital_head.php'; ?>
<?php include '../includes/hospital_header.php'; ?>
<?php include '../includes/hospital_sidebar.php'; ?>

<style>
.content-wrapper { margin-left:260px; padding:28px; }

.form-container { max-width:1150px; margin:auto; }
.form-card {
    background:#fff;
    padding:35px;
    border-radius:14px;
    box-shadow:0 4px 18px rgba(0,0,0,0.07);
}
.form-title { font-size:26px; font-weight:700; color:#003c71; }
.form-sub { font-size:14px; color:#777; margin-bottom:25px; }

.form-grid {
    display:grid;
    grid-template-columns:1fr 1fr;
    gap:22px 40px;
}
@media(max-width:768px){
    .form-grid{ grid-template-columns:1fr; }
}

.form-group { display:flex; flex-direction:column; }
label { font-weight:600; margin-bottom:6px; }

.form-control, .form-select {
    height:48px;
    border-radius:8px;
    padding:10px;
    border:1px solid #cfd7e3;
}
textarea.form-control{ height:auto; }

.form-control:focus, .form-select:focus {
    border-color:#0d6efd;
    box-shadow:0 0 0 2px rgba(13,110,253,.18);
}
</style>

<div class="content-wrapper">
    <div class="form-container">
        <div class="form-card">

            <h3 class="form-title">Edit Doctor</h3>
            <p class="form-sub">Update doctor information</p>

            <form method="POST" enctype="multipart/form-data">

                <input type="hidden" name="doctor_id" value="<?= $doctor_id ?>">
                <input type="hidden" name="existing_photo" value="<?= $doctor['profile_photo'] ?>">
                <input type="hidden" name="existing_documents" value="<?= $doctor['documents'] ?>">

                <div class="form-grid">

                    <div class="form-group">
                        <label>Doctor Name</label>
                        <input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($doctor['full_name']) ?>" required>
                    </div>

                    <div class="form-group">
                        <label>Specialization</label>
                        <input type="text" name="specialization" class="form-control" value="<?= htmlspecialchars($doctor['specialization']) ?>">
                    </div>

                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($doctor['email']) ?>">
                    </div>

                    <div class="form-group">
                        <label>Phone</label>
                        <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($doctor['phone']) ?>">
                    </div>

                    <div class="form-group">
                        <label>Gender</label>
                        <select name="gender" class="form-select">
                            <option <?= $doctor['gender']=="Male"?'selected':'' ?>>Male</option>
                            <option <?= $doctor['gender']=="Female"?'selected':'' ?>>Female</option>
                            <option <?= $doctor['gender']=="Other"?'selected':'' ?>>Other</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Date of Birth</label>
                        <input type="date" name="dob" class="form-control" value="<?= $doctor['dob'] ?>">
                    </div>

                    <div class="form-group">
                        <label>Qualification</label>
                        <input type="text" name="qualification" class="form-control" value="<?= htmlspecialchars($doctor['qualification']) ?>">
                    </div>

                    <div class="form-group">
                        <label>Salary</label>
                        <input type="number" name="salary" class="form-control" value="<?= $doctor['salary'] ?>">
                    </div>

                    <div class="form-group">
                        <label>Joining Date</label>
                        <input type="date" name="joining_date" class="form-control" value="<?= $doctor['joining_date'] ?>">
                    </div>

                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" class="form-select">
                            <option <?= $doctor['status']=="Active"?'selected':'' ?>>Active</option>
                            <option <?= $doctor['status']=="Inactive"?'selected':'' ?>>Inactive</option>
                        </select>
                    </div>

                    <!-- EXPERIENCE -->
                    <div class="form-group">
                        <label>Experience (Years)</label>
                        <input type="number" name="experience_years" class="form-control" value="<?= $doctor['experience_years'] ?>">
                    </div>

                    <div class="form-group" style="grid-column:span 2;">
                        <label>Experience Details</label>
                        <textarea name="experience_details" class="form-control" rows="3"><?= htmlspecialchars($doctor['experience_details']) ?></textarea>
                    </div>

                    <div class="form-group">
                        <label>Profile Photo</label>
                        <?php if($doctor['profile_photo']): ?>
                            <img src="/multi_hospital2/uploads/doctors/<?= $doctor['profile_photo'] ?>" width="60" style="border-radius:50%;margin-bottom:6px;">
                        <?php endif; ?>
                        <input type="file" name="profile_photo" class="form-control">
                    </div>

                    <div class="form-group">
                        <label>Documents</label>
                        <input type="file" name="documents[]" class="form-control" multiple>
                    </div>

                </div>

                <div class="text-end mt-4">
                    <a href="view_doctor_list.php" class="btn btn-outline-secondary">Cancel</a>
                    <button type="submit" name="update_doctor" class="btn btn-primary">Update Doctor</button>
                </div>

            </form>

        </div>
    </div>
</div>

<?php include '../includes/hospital_scripts.php'; ?>
</body>
</html>
