<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

// 🔒 Login Check
if(!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']){
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

// 🧾 Handle Add Weekly Schedule
if(isset($_POST['add_schedule'])){
    $staff_id   = $_POST['staff_id'];
    $staff_type = $_POST['staff_type'];
    $staff_code = $_POST['staff_code'];
    $full_name  = $_POST['full_name'];
    $fee        = $_POST['fee'] ?? 0;

    $days = ['monday','tuesday','wednesday','thursday','friday','saturday','sunday'];
    $time_data = [];
    foreach($days as $d){
        $time_data[$d.'_start'] = $_POST[$d.'_start'] ?? null;
        $time_data[$d.'_end']   = $_POST[$d.'_end'] ?? null;
    }

$sql = "INSERT INTO schedule (
     hospital_id, staff_type, staff_id, full_name, fee,
    monday_start, monday_end,
    tuesday_start, tuesday_end,
    wednesday_start, wednesday_end,
    thursday_start, thursday_end,
    friday_start, friday_end,
    saturday_start, saturday_end,
    sunday_start, sunday_end
) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);

$stmt->bind_param(
    "isssdssssssssssssss",
    $hospital_id,
    $staff_type,
    $staff_code,
    $full_name,
    $fee,
    $time_data['monday_start'],
    $time_data['monday_end'],
    $time_data['tuesday_start'],
    $time_data['tuesday_end'],
    $time_data['wednesday_start'],
    $time_data['wednesday_end'],
    $time_data['thursday_start'],
    $time_data['thursday_end'],
    $time_data['friday_start'],
    $time_data['friday_end'],
    $time_data['saturday_start'],
    $time_data['saturday_end'],
    $time_data['sunday_start'],
    $time_data['sunday_end']
);

    if($stmt->execute()){
        header("Location: view_doctor_schedule.php?success=1");
        exit;
    } else {
        $msg = "<div class='alert alert-danger'>❌ Failed to save schedule.<br>".$stmt->error."</div>";
    }
}

$staffs = $conn->query("SELECT id, staff_id, staff_type, full_name FROM doctors WHERE hospital_id='$hospital_id' ORDER BY full_name ASC");
?>


<?php include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_head.php'; ?>

<!-- ⭐ PREMIUM UI CSS -->
<style>
.schedule-card {
    background: #ffffff;
    border-radius: 12px;
    padding: 25px;
    margin-top: 20px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
}

.content-wrapper {
    margin-left: 260px !important;
    margin-top: 70px !important;
    padding: 20px;
}

.section-title {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 18px;
    color: #0d6efd;
    border-left: 4px solid #0d6efd;
    padding-left: 10px;
}

form label {
    font-weight: 600;
    color: #333;
}

.form-control {
    border-radius: 8px !important;
}

.table thead {
    background: #eef4ff;
    color: #003d9c;
    font-weight: 600;
}

.table td {
    vertical-align: middle !important;
}

.btn-save {
    padding: 12px 35px;
    font-size: 17px;
    font-weight: 600;
    border-radius: 8px;
}

.day-name {
    font-weight: 600;
    text-transform: capitalize;
}
</style>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

<?php include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_header.php'; ?>
<?php include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_sidebar.php'; ?>

<div class="content-wrapper">

<section class="content-header d-flex justify-content-between align-items-center">
    <h1>Add Weekly Schedule</h1>
    <a href="view_doctor_schedule.php" class="btn btn-default">← Back to Schedule List</a>
</section>

<section class="content">

<div class="schedule-card">

    <h3 class="section-title">👨‍⚕️ Staff Information</h3>

    <?php if(isset($msg)) echo $msg; ?>

    <form method="POST">

        <div class="row mb-4">

            <div class="col-md-3">
                <label>Select Staff</label>
                <select name="staff_id" id="staff_select" class="form-control" required>
                    <option value="">Select Staff</option>
                    <?php while($row = $staffs->fetch_assoc()): ?>
                        <option value="<?= $row['id']; ?>"
                                data-fullname="<?= htmlspecialchars($row['full_name']); ?>"
                                data-type="<?= htmlspecialchars($row['staff_type']); ?>"
                                data-staffcode="<?= htmlspecialchars($row['staff_id']); ?>">
                            <?= htmlspecialchars($row['full_name']); ?> (<?= $row['staff_type']; ?>)
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="col-md-3">
                <label>Staff ID</label>
                <input type="text" id="staff_code" name="staff_code" class="form-control" readonly required>
            </div>

            <div class="col-md-3">
                <label>Staff Type</label>
                <input type="text" id="staff_type" name="staff_type" class="form-control" readonly required>
            </div>

            <div class="col-md-3">
                <label>Full Name</label>
                <input type="text" id="full_name" name="full_name" class="form-control" readonly required>
            </div>

        </div>

        <div class="form-group mb-4">
            <label>Consultation Fee (₹)</label>
            <input type="number" step="0.01" name="fee" class="form-control" value="0.00" required>
        </div>

        <h3 class="section-title">🗓 Weekly Schedule Timings</h3>

        <div class="table-responsive mb-4">
            <table class="table table-bordered text-center">
                <thead>
                    <tr>
                        <th>Day</th>
                        <th>Start Time</th>
                        <th>End Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $days = ['monday','tuesday','wednesday','thursday','friday','saturday','sunday'];
                    foreach($days as $day): ?>
                    <tr>
                        <td class="day-name"><?= $day; ?></td>
                        <td><input type="time" name="<?= $day; ?>_start" class="form-control"></td>
                        <td><input type="time" name="<?= $day; ?>_end" class="form-control"></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <button type="submit" name="add_schedule" class="btn btn-success btn-save">
            💾 Save Weekly Schedule
        </button>

    </form>
</div>

</section>
</div>

<?php include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_scripts.php'; ?>

<!-- 🧠 Auto-fill Staff Info -->
<script>
document.addEventListener('DOMContentLoaded', function(){
  const staffSelect = document.getElementById('staff_select');
  const fullNameInput = document.getElementById('full_name');
  const typeInput = document.getElementById('staff_type');
  const codeInput = document.getElementById('staff_code');

  staffSelect.addEventListener('change', function(){
    const selected = staffSelect.options[staffSelect.selectedIndex];
    fullNameInput.value = selected.dataset.fullname || '';
    typeInput.value = selected.dataset.type || '';
    codeInput.value = selected.dataset.staffcode || '';
  });
});
</script>

</body>
</html>
