<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

// =====================================
// LOGIN CHECK
// =====================================
if(!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']){
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

// =====================================
// GET SCHEDULE ID
// =====================================
if(!isset($_GET['id']) || empty($_GET['id'])){
    header("Location: ./view_doctor_schedule.php");
    exit;
}

$id = intval($_GET['id']);

// =====================================
// FETCH EXISTING SCHEDULE
// =====================================
$sql = "SELECT * FROM schedule WHERE id = ? AND hospital_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $id, $hospital_id);
$stmt->execute();
$result = $stmt->get_result();

if($result->num_rows == 0){
    header("Location: ./view_doctor_schedule.php?error=Not+found");
    exit;
}

$data = $result->fetch_assoc();
$stmt->close();

// =====================================
// UPDATE SCHEDULE
// =====================================
if(isset($_POST['update'])){

    $full_name  = $_POST['full_name'];
    $staff_id   = $_POST['staff_id'];
    $staff_type = $_POST['staff_type'];
    $fee        = $_POST['fee'];

    // Weekly timings
    $days = ['monday','tuesday','wednesday','thursday','friday','saturday','sunday'];
    $time = [];

    foreach($days as $d){
        $time[$d.'_start'] = $_POST[$d.'_start'];
        $time[$d.'_end']   = $_POST[$d.'_end'];
    }

    $update = "UPDATE schedule SET 
        full_name=?, 
        staff_id=?, 
        staff_type=?, 
        fee=?,
        monday_start=?, monday_end=?,
        tuesday_start=?, tuesday_end=?,
        wednesday_start=?, wednesday_end=?,
        thursday_start=?, thursday_end=?,
        friday_start=?, friday_end=?,
        saturday_start=?, saturday_end=?,
        sunday_start=?, sunday_end=?
        WHERE id=? AND hospital_id=?";

    $stmt2 = $conn->prepare($update);
    $stmt2->bind_param(
        "ssssssssssssssssssii",
        $full_name, $staff_id, $staff_type, $fee,
        $time['monday_start'], $time['monday_end'],
        $time['tuesday_start'], $time['tuesday_end'],
        $time['wednesday_start'], $time['wednesday_end'],
        $time['thursday_start'], $time['thursday_end'],
        $time['friday_start'], $time['friday_end'],
        $time['saturday_start'], $time['saturday_end'],
        $time['sunday_start'], $time['sunday_end'],
        $id, $hospital_id
    );

    if($stmt2->execute()){
        header("Location: ./view_doctor_schedule.php?success=1");
        exit;
    }

    echo "<script>alert('Something went wrong!');</script>";
}

include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_head.php';
?>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

<?php 
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_header.php';
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_sidebar.php';
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>Edit Weekly Schedule</h1>
    </section>

    <section class="content">
        <div class="box box-primary">
            <div class="box-body">
                <form method="POST">

                    <!-- Doctor Info -->
                    <h4 class="mt-3">Doctor Details</h4>

                    <div class="row">
                        <div class="col-md-4">
                            <label>Full Name</label>
                            <input type="text" name="full_name" class="form-control" value="<?= $data['full_name']; ?>" required>
                        </div>

                        <div class="col-md-4">
                            <label>Staff ID</label>
                            <input type="text" name="staff_id" class="form-control" value="<?= $data['staff_id']; ?>">
                        </div>

                        <div class="col-md-4">
                            <label>Type</label>
                            <select name="staff_type" class="form-control">
                                <option <?= ($data['staff_type']=="Doctor"?"selected":""); ?>>Doctor</option>
                                <option <?= ($data['staff_type']=="Nurse"?"selected":""); ?>>Nurse</option>
                                <option <?= ($data['staff_type']=="Consultant"?"selected":""); ?>>Consultant</option>
                            </select>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <label>Fee (₹)</label>
                            <input type="number" name="fee" class="form-control" value="<?= $data['fee']; ?>">
                        </div>
                    </div>

                    <hr>

                    <!-- Weekly Schedule -->
                    <h4>Weekly Schedule</h4>

                    <?php
                    $days = [
                        "monday" => "Monday",
                        "tuesday" => "Tuesday",
                        "wednesday" => "Wednesday",
                        "thursday" => "Thursday",
                        "friday" => "Friday",
                        "saturday" => "Saturday",
                        "sunday" => "Sunday"
                    ];

                    foreach($days as $key => $label){
                        $start = $key."_start";
                        $end = $key."_end";
                    ?>
                        <div class="row mb-2">
                            <div class="col-md-3"><strong><?= $label ?>:</strong></div>
                            <div class="col-md-3">
                                <input type="time" name="<?= $start ?>" class="form-control" value="<?= $data[$start]; ?>">
                            </div>
                            <div class="col-md-3">
                                <input type="time" name="<?= $end ?>" class="form-control" value="<?= $data[$end]; ?>">
                            </div>
                        </div>
                    <?php } ?>

                    <br>

                    <button type="submit" name="update" class="btn btn-success">Update Schedule</button>
                    <a href="./view_doctor_schedule.php" class="btn btn-secondary">Cancel</a>

                </form>
            </div>
        </div>
    </section>
</div>

<?php include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/hospital/includes/hospital_scripts.php'; ?>
</body>
</html>
