<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

// Redirect not logged-in hospitals
if (!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']) {
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

// Delete weekly schedule
if (isset($_GET['delete_id'])) {
    $del_id = intval($_GET['delete_id']);
    $conn->query("DELETE FROM schedule WHERE id='$del_id' AND hospital_id='$hospital_id'");
    header("Location: view_doctor_schedule.php?deleted=1");
    exit;
}

// Auto-load header/sidebar/scripts
include __DIR__ . '/../../includes/autoload.php';

$days = [
    "monday" => "Monday",
    "tuesday" => "Tuesday",
    "wednesday" => "Wednesday",
    "thursday" => "Thursday",
    "friday" => "Friday",
    "saturday" => "Saturday",
    "sunday" => "Sunday"
];

// Format timing
function showTime($s, $e) {
    if (empty($s) || empty($e) || $s == "00:00:00" || $e == "00:00:00") {
        return ["N/A", false];
    }
    return [date("h:i A", strtotime($s)) . " - " . date("h:i A", strtotime($e)), true];
}
?>

<style>
.content-wrapper {
    margin-left: 260px;
    margin-top: 90px;
    padding: 25px;
    background: #f5f7fb;
    min-height: 100vh;
}

.table thead {
    background: #f0f2f5;
    font-weight: bold;
}

.badge-available {
    background: #198754;
    padding: 4px 10px;
    border-radius: 8px;
    font-size: 12px;
    color: white;
}

.badge-na {
    background: #6c757d;
    padding: 4px 10px;
    border-radius: 8px;
    font-size: 12px;
    color: white;
}

.doctor-name {
    font-weight: bold;
    font-size: 15px;
    color: #0d6efd;
}

/* Action dropdown button */
.action-btn {
    background: #f8f9fa;
    transition: 0.2s;
}

.action-btn:hover {
    background: #e9ecef;
    transform: scale(1.1);
}

/* Dropdown Menu */
.dropdown-menu {
    border-radius: 10px;
    border: none;
    box-shadow: 0 3px 10px rgba(0,0,0,0.15);
}

.dropdown-menu li a {
    padding: 8px 14px;
    font-size: 14px;
}

.dropdown-menu li a:hover {
    background: #f1f3f5;
}
</style>



<div class="content-wrapper">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="fa-solid fa-calendar-days"></i> Doctor Weekly Schedule</h3>
        <a href="add_schedule.php" class="btn btn-primary">
            <i class="fa-solid fa-plus"></i> Add Weekly Schedule
        </a>
    </div>

    <?php if (isset($_GET['deleted'])): ?>
        <div class="alert alert-danger">🗑️ Schedule deleted successfully!</div>
    <?php endif; ?>

    <div class="card-modern p-3">
        <h5 class="mb-3">Weekly Schedule Calendar</h5>

        <table class="table table-bordered text-center">
            <thead>
                <tr>
                    <th>Doctor</th>
                    <?php foreach ($days as $d) echo "<th>$d</th>"; ?>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>

            <?php
            $sql = "
                SELECT sc.*, d.full_name 
                FROM schedule sc
                LEFT JOIN doctors d ON d.staff_id = sc.staff_id
                WHERE sc.hospital_id = ?
                ORDER BY d.full_name ASC
            ";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $hospital_id);
            $stmt->execute();
            $res = $stmt->get_result();

            if ($res->num_rows == 0) {
                echo "<tr><td colspan='10' class='text-muted'>No schedules found.</td></tr>";
            }

            while ($row = $res->fetch_assoc()):
            ?>
                <tr>
                    <td class="doctor-name"><?= $row['full_name'] ?></td>

                    <?php foreach ($days as $key => $label): 
                        list($time, $active) = showTime($row[$key."_start"], $row[$key."_end"]);
                    ?>
                        <td>
                            <?php if ($active): ?>
                                <span class="badge-available">Available</span><br>
                                <?= $time ?>
                            <?php else: ?>
                                <span class="badge-na">N/A</span>
                            <?php endif; ?>
                        </td>
                    <?php endforeach; ?>

                    <td>
                        <div class="dropdown">
                            <button class="btn btn-light btn-sm border rounded-pill px-3 py-1 action-btn"
                                    type="button" data-bs-toggle="dropdown" style="background-color: #0d6efd61;font-weight: bold;">
                                Actions 
                            </button>

                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item d-flex align-items-center gap-2"
                                       href="edit_doctor_schedule.php?id=<?= $row['id']; ?>">
                                        <i class="fa fa-pen text-primary"></i>
                                        <span>Edit Schedule</span>
                                    </a>
                                </li>

                                <li>
                                    <a class="dropdown-item text-danger d-flex align-items-center gap-2"
                                       href="?delete_id=<?= $row['id']; ?>"
                                       onclick="return confirm('Delete complete weekly schedule?');">
                                        <i class="fa fa-trash"></i>
                                        <span>Delete Schedule</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </td>

                </tr>
            <?php endwhile; ?>

            </tbody>
        </table>
    </div>

</div>

<script src="<?php echo $_SERVER['DOCUMENT_ROOT']; ?>/multi_hospital2/hospital/assets/js/main.js"></script>

<!-- NO EXTRA JS HERE (IMPORTANT) -->
</body>
</html>
